package nn.pp.rckbd;

import java.awt.event.*;
import java.util.*;

/**
 * that is the default Key Translator what is en_US
 * we define this class without the specific suffixes
 * as everything will fallback to it if nothing else
 * is available
 */
public class KeyTranslator extends KeyTranslatorBase {

    public KeyTranslator() {
	addKeyTranslation(codetable);
    }

    public Locale getLocale() {
	return new Locale("en", "US");
    }

    private static int[][] codetable = {
	{ KeyEvent.VK_BACK_QUOTE, 0 },
	{ KeyEvent.VK_1, 1 },
	{ KeyEvent.VK_2, 2 },
	{ KeyEvent.VK_3, 3 },
   	{ KeyEvent.VK_4, 4 },
   	{ KeyEvent.VK_5, 5 },
   	{ KeyEvent.VK_6, 6 },
   	{ KeyEvent.VK_7, 7 },
   	{ KeyEvent.VK_8, 8 },
   	{ KeyEvent.VK_9, 9 },
   	{ KeyEvent.VK_0, 10 },
   	{ KeyEvent.VK_MINUS, 11 },	
   	{ KeyEvent.VK_EQUALS, 12 },	
   	{ KeyEvent.VK_BACK_SPACE, 13 },	
   	{ KeyEvent.VK_TAB, 14 },	
   	{ KeyEvent.VK_Q, 15 },	
   	{ KeyEvent.VK_W, 16 },	
   	{ KeyEvent.VK_E, 17 },	
   	{ KeyEvent.VK_R, 18 },	
   	{ KeyEvent.VK_T, 19 },	
   	{ KeyEvent.VK_Y, 20 },	
   	{ KeyEvent.VK_U, 21 },
   	{ KeyEvent.VK_I, 22 },
   	{ KeyEvent.VK_O, 23 },
   	{ KeyEvent.VK_P, 24 },
   	{ KeyEvent.VK_OPEN_BRACKET, 25 },
   	{ KeyEvent.VK_CLOSE_BRACKET, 26 },
   	{ KeyEvent.VK_ENTER, 27 },
   	{ KeyEvent.VK_CAPS_LOCK, 28 },
   	{ KeyEvent.VK_A, 29 },
   	{ KeyEvent.VK_S, 30 },
   	{ KeyEvent.VK_D, 31 },
   	{ KeyEvent.VK_F, 32 },
   	{ KeyEvent.VK_G, 33 },
   	{ KeyEvent.VK_H, 34 },
   	{ KeyEvent.VK_J, 35 },
   	{ KeyEvent.VK_K, 36 },
   	{ KeyEvent.VK_L, 37 },
   	{ KeyEvent.VK_SEMICOLON, 38 },
   	{ KeyEvent.VK_QUOTE, 39 },
   	{ KeyEvent.VK_BACK_SLASH, 40 },
   	{ KeyEvent.VK_SHIFT, 41 },
   	// { KeyEvent.VK_BACK_QUOTE, 42 }, not used in English
   	{ KeyEvent.VK_Z, 43 },
   	{ KeyEvent.VK_X, 44 },
   	{ KeyEvent.VK_C, 45 },
   	{ KeyEvent.VK_V, 46 },
   	{ KeyEvent.VK_B, 47 },
   	{ KeyEvent.VK_N, 48 },
   	{ KeyEvent.VK_M, 49 },
   	{ KeyEvent.VK_COMMA, 50 },
   	{ KeyEvent.VK_PERIOD, 51 },
   	{ KeyEvent.VK_SLASH, 52 },
   	{ KeyEvent.VK_CONTROL, 54 },
   	{ KeyEvent.VK_ALT, 55 },
   	{ KeyEvent.VK_SPACE, 56 },

   	{ KeyEvent.VK_ESCAPE, 59 },
   	{ KeyEvent.VK_F1, 60 },
   	{ KeyEvent.VK_F2, 61 },
   	{ KeyEvent.VK_F3, 62 },
   	{ KeyEvent.VK_F4, 63 },
   	{ KeyEvent.VK_F5, 64 },
   	{ KeyEvent.VK_F6, 65 },
   	{ KeyEvent.VK_F7, 66 },
   	{ KeyEvent.VK_F8, 67 },
   	{ KeyEvent.VK_F9, 68 },
   	{ KeyEvent.VK_F10, 69 },
   	{ KeyEvent.VK_F11, 70 },
   	{ KeyEvent.VK_F12, 71 },
   	{ KeyEvent.VK_PRINTSCREEN, 72 },
   	{ KeyEvent.VK_SCROLL_LOCK, 73 },
   	{ KeyEvent.VK_PAUSE, 74 },
   	{ KeyEvent.VK_CANCEL, 129 },	// dummy entry for Ctrl+Break
   	{ KeyEvent.VK_INSERT, 75 },
   	{ KeyEvent.VK_HOME, 76 },
   	{ KeyEvent.VK_PAGE_UP, 77 },
   	{ KeyEvent.VK_DELETE, 78 },
   	{ KeyEvent.VK_END, 79 },
   	{ KeyEvent.VK_PAGE_DOWN, 80 },

   	{ KeyEvent.VK_UP, 81 },
   	{ KeyEvent.VK_LEFT, 82 },
   	{ KeyEvent.VK_DOWN, 83 },
   	{ KeyEvent.VK_RIGHT, 84 },

	{ KeyEvent.VK_KP_UP, 87 },
	{ KeyEvent.VK_KP_LEFT, 91 },
	{ KeyEvent.VK_KP_DOWN, 96 },
	{ KeyEvent.VK_KP_RIGHT, 93 },
	
   	{ KeyEvent.VK_NUM_LOCK, 85 },
   	{ KeyEvent.VK_NUMPAD7, 86 },
   	{ KeyEvent.VK_NUMPAD8, 87 },
   	{ KeyEvent.VK_NUMPAD9, 88 },
   	{ KeyEvent.VK_ADD, 89 },
   	{ KeyEvent.VK_DIVIDE, 90 },
   	{ KeyEvent.VK_NUMPAD4, 91 },
   	{ KeyEvent.VK_NUMPAD5, 92 },
   	{ KeyEvent.VK_NUMPAD6, 93 },
   	{ KeyEvent.VK_MULTIPLY, 94 },
   	{ KeyEvent.VK_NUMPAD1, 95 },
   	{ KeyEvent.VK_NUMPAD2, 96 },
   	{ KeyEvent.VK_NUMPAD3, 97 },
   	{ KeyEvent.VK_SUBTRACT, 99 },
   	{ KeyEvent.VK_NUMPAD0, 100 },
   	{ KeyEvent.VK_DECIMAL, 101 },

	{ KeyEvent.VK_META, 105 },
	// TODO: replace constant with symbolic one,
	// ones version of compile SDK knows the symbol
	{ 524 /* KeyEvent.VK_WINDOWS */, 105 },
	{ 525 /* KeyEvent.VK_CONTEXT_MENU */, 106 },

	// some special codes for IE on Windows
	{ 220, 40 }, // \
	{ 219, 25 }, // [
	{ 221, 26 }, // ]
	{ 186, 38 }, // ;
	{ 188, 50 }, // ,
	{ 190, 51 }, // .
	{ 191, 52 }, // /
	{ 187, 12 }, // =
	{ 189, 11 }, // -
    };
}   	
   
