package nn.pp.rckbd;

import java.awt.event.*;
import java.util.*;

/**
 * that is the default Key Translator what is en_US
 * we define this class without the specific suffixes
 * as everything will fallback to it if nothing else
 * is available
 */
public class KeyTranslator_de extends KeyTranslator {

    public KeyTranslator_de() {
	String jv = System.getProperty("java.vendor");	
	if(jv.startsWith("Microsoft")) {
	    addKeyTranslation(codetable_ms);
	} else {
	    addKeyTranslation(codetable);
	}
	addCharTranslation(chartable);
    }

    public Locale getLocale() {
	return new Locale("de", "DE");
    }

    private static int[][] chartable = {
	{ '?', 11 },
	{ '\\',11 },
	{ '_', 52 },
	{ '<', 42 },
	{ '>', 42 },
	{ '|', 42 },
	{ '~', 26 },
	{ '#', 40 },
	{ '\'', 40 },
	{ '\u00f6', 38 }, // 
	{ '\u00d6', 38 }, // 
	{ '\u00e4', 39 }, // 
	{ '\u00c4', 39 }, // 
	{ '\u00fc', 25 }, // 
	{ '\u00dc', 25 }, // 
	{ '\u00df', 11 }, // 
	{ '\u00b4', 12 }, //
	{ '\u0060', 12 }  // `
    };

    private static int[][] codetable = {
   	{ KeyEvent.VK_Y, 43 },
   	{ KeyEvent.VK_Z, 20 },

	{ KeyEvent.VK_MINUS, 52 },
	{ KeyEvent.VK_NUMBER_SIGN, 40 },

	{ KeyEvent.VK_ALT_GRAPH, 57 },     // for Java 2
	{ KeyEvent.VK_DEAD_CIRCUMFLEX, 0 },
	{ KeyEvent.VK_CIRCUMFLEX, 0},
	{ KeyEvent.VK_DEAD_ACUTE, 12 },
	{ KeyEvent.VK_LESS, 42 },
	{ KeyEvent.VK_BACK_SLASH, 0 },     // ^
	{ KeyEvent.VK_CLOSE_BRACKET, 12 }, // '
	{ KeyEvent.VK_EQUALS, 26 },        // +
	{ KeyEvent.VK_SLASH, 40 },         // #
	{ KeyEvent.VK_PLUS, 26 },          // +

	// special keys for NS
	{ 0x15, 57 },                  // alt gr

	// special keys for java 1.1 under OS/2
	{ 187, 12 }
    };

    private static int[][] codetable_ms = {
   	{ KeyEvent.VK_Y, 43 },
   	{ KeyEvent.VK_Z, 20 },

	{ KeyEvent.VK_MINUS, 52 },
	{ KeyEvent.VK_NUMBER_SIGN, 40 },

	// special keys for IE
	{ 220, 0  }, // ^
	{ 219, 11 }, // 
	{ 221, 12 }, // `
	{ 187, 26 }, // +
	{ 191, 40 }, // #
	{ 226, 42 }, // <
	{ 189, 52 }, // -
	{ 186, 25 }, // 
    };
}

