package nn.pp.rckbd;

import java.awt.event.*;
import java.util.*;

/**
 * that is the default Key Translator what is en_US
 * we define this class without the specific suffixes
 * as everything will fallback to it if nothing else
 * is available
 */
public class KeyTranslator_ja extends KeyTranslator {

    public KeyTranslator_ja() {
	String jv = System.getProperty("java.vendor");
	if(jv.startsWith("Microsoft")) {
	    addKeyTranslation(codetable_ms);
	} else {
	    addKeyTranslation(codetable);
	}
	addCharTranslation(chartable);
    }
    
    public Short translateKeyEvent(KeyEvent evt) {
	Short r = super.translateKeyEvent(evt);
	
	if ( evt.getKeyCode() == 240 ) {
		if (evt.getID() == KeyEvent.KEY_PRESSED) {
			r = new Short((short)28);
		} else if (evt.getID() == KeyEvent.KEY_RELEASED) {
			r = new Short((short)110);
		}
	}
	return r;
    }

    public Locale getLocale() {
	return new Locale("ja", "JP");
    }

    private static int[][] chartable = {	
	{ '_', 114 },					// shift + left from right shift									
	{ '|', 112  },					// shift + left from backspace
    };
    
    private static int[][] codetable = {
   	{ 28, 109 },				// Muhenkan
   	{ 29, 108 },				// Henkan
	{ 241, 110 },				// Katagana
	{ 242, 110 },				// Hiragana
	{ 243, 0 },				// Fullwidth
	{ 244, 0 },				// Halfwidth
	{ 245, 110 },				// Roman Character
	{ 512, 25 },				// VK_AT
	{ 513, 39 },				// VK_COLON	
	{ 514, 12 },
	{ 91,  26 },
	{ 92, 112 },
	{ 93, 40  },
    };

    private static int[][] codetable_ms = {
	{ 220, 112 },				// Yen
	{ 222, 12  },				// ^
	{ 192, 25  },				// @
	{ 219, 26  },				// [
	{ 187, 38  },				// ;
	{ 186, 39  },				// :
	{ 221, 40  },				// ]
	{ 226, 112 },				// Yen
    };
}