package nn.pp.rcrdp;

class BitmapDecompressor {
    private boolean debug = false;
    
    private byte[] buffer = null;
    private int[] intBuffer = null;
    
    private ColorTranslator colorTranslator;
    
    private void debug(String s) {
    	if(debug) System.out.println(s);
    }
    
    // Constructor
    public BitmapDecompressor() {
    }

    public void setColorTranslator(ColorTranslator c) {
    	colorTranslator = c;
    }
    
    private byte zeroes[] = new byte[1000];	// automatically filled with 0

    private byte ffs[] = { (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                           (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                           (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                           (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                           (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                           (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                           (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff,
                           (byte) 0xff, (byte) 0xff, (byte) 0xff, (byte) 0xff };
    
    // get and allocate (if necessary) the internal buffer
    private byte[] getBuffer(int size) {
    	if(buffer == null || buffer.length < size) {
    	    buffer = new byte[size];
    	}
    	
    	return buffer;
    }
    
    private int[] getIntBuffer(int size) {
    	if(intBuffer == null || intBuffer.length < size) {
    	    intBuffer = new int[size];
    	}
    	
    	return intBuffer;
    }
    
    // read a number of bytes and store it in an int
    private int cvalx(byte data[], int offset, int len) {
        int ret = 0;
        for(int i = len; i > 0; i--) {
            ret <<= 8;
            ret += (data[offset + i - 1] & 0xff);
        }
        return ret;
    }
    
    // read one byte from the data source
    
    private int cval(byte[] data, int offset) {
    	return (data[offset] & 0xff);
    }
    
    private byte cvalb(byte[] data, int offset) {
    	return data[offset];
    }
    
    // this define isn't the clean way, but for such short functions
    // it is faster to use inline functions which aren't supported by Java;
    // we push the code through a C++ preprocessor anyway, so we can use it for us
//#define cval(data, offset) ((data)[(offset)] & 0xff)
//#define cvalb(data, offset) ((byte) ((data)[(offset)] & 0xff))
    
    // set a pixel in a line
    public void setli(byte input[], int pos, int offset, int value, int bpp) {
        offset *= bpp;
        offset += pos;
        for(int i = 0; i < bpp; i++) {
            input[offset++] = (byte) ((value >> (i * 8)) & 0xff);
        }
    }
    
    // read a pixel in a line
    // I don't know how to do this by a define, so I leave it as function here
    private int getli(byte input[], int pos, int offset, int bpp) {
        int ret = 0;
        offset *= bpp;
        offset += pos;
        for(int i = bpp; i > 0; i--) {
            ret <<= 8;
            ret += (input[offset + i - 1] & 0xff);
        }
        return ret;
    }
    
    // check if the zeroes buffer is large enough and enlarge if necessary
    private void checkZeroes(int size) {
    	if(zeroes.length < size) {
    	    zeroes = new byte[size];
    	}
    }
    
    // decompress an 8 bit/pixel image
    // this function is a little more optimized for speed
    public int[] decompress8(byte data[], int width, int height, int size) {
    	byte[] out = getBuffer(width * height);    	
    	
    	int end = size;
    	int input = 0, output = 0;
    	int prevLine = 0, line = 0;
    	int opcode, count = 0, offset, x = width;
    	int lastOpcode = -1;
    	boolean insertMix = false, biColor = false, isFillOrMix = false;
	int code;
	byte color1 = (byte) 0, color2 = (byte) 0;
	byte mixMask, mask = (byte) 0;
	byte mix = (byte) 0xff;
	byte fomMask = (byte) 0;
	
	int oldX, loops;
	
	int i;
	
	// debugging
	int inWidth = width;
	int inHeight = height;
    	
    	while(input < end) {
    	    fomMask = (byte) 0;
    	    code = data[input++] & 0xff;
    	    opcode = code >> 4;
    	    
    	    // Handle different opcode forms
    	    switch(opcode) {
    	    	case 0xc:
    	    	case 0xd:
    	    	case 0xe:
    	    	    opcode -= 6;
    	    	    count = code & 0xf;
    	    	    offset = 16;
    	    	    break;
    	    	case 0xf:
    	    	    opcode = code & 0xf;
    	    	    if(opcode < 9) {
    	    	    	count = data[input++] & 0xff;
    	    	    	count |= (data[input++] & 0xff) << 8;
    	    	    }
    	    	    else {
    	    	    	count = (opcode < 0xb) ? 8 : 1;
    	    	    }
    	    	    offset = 0;
    	    	    break;
    	    	default:
    	    	    opcode >>= 1;
		    count = code & 0x1f;
		    offset = 32;
		    break;
    	    }
    	    
    	    // Handle strange cases for counts
    	    if(offset != 0) {
    	    	isFillOrMix =  ((opcode == 2) || (opcode == 7));
    	    	if(count == 0) {
    	    	    if(isFillOrMix) {
    	    	    	count = (data[input++] & 0xff) + 1;
    	    	    }
    	    	    else {
    	    	    	count = (data[input++] & 0xff) + offset;
    	    	    }
    	    	}
    	    	else if(isFillOrMix) {
    	    	    count <<= 3;
    	    	}
    	    }
    	    
    	    // Read preliminary data
    	    switch(opcode) {
    	    	case 0:		// Fill
    	    	    if((lastOpcode == opcode) && !((x == width) && (prevLine == 0))) {
    	    	    	insertMix = true;
    	    	    }
    	    	    break;
    	    	case 8:		// Bicolor
    	    	    color1 = data[input++];
    	    	    // fall through
    	    	case 3:		// Color
    	    	    color2 = data[input++];
    	    	    break;
    	    	case 6:		// SetMix/Mix
    	    	case 7:		// SetMix/FillOrMix
    	    	    mix = data[input++];
    	    	    opcode -= 5;
    	    	    break;
    	    	case 9:		// FillOrMix_1
    	    	    mask = (byte) 0x3;
    	    	    opcode = 0x2;
    	    	    fomMask = (byte) 3;
    	    	    break;
    	    	case 0x0a:	// fillOrMix_2
    	    	    mask = (byte) 0x05;
    	    	    opcode = 0x02;
    	    	    fomMask = (byte) 5;
    	    	    break;
    	    }
    	    
    	    lastOpcode = opcode;
    	    mixMask = 0;
    	    
    	    // Output body
    	    while(count > 0) {
    	    	if(x >= width) {
    	    	    if(height <= 0) {
    	    	    	debug("RDP BitmapDecompressor: height <= 0");
    	    	    	return null;
    	    	    }
    	    	    
    	    	    x = 0;
    	    	    height--;
    	    	    
    	    	    prevLine = line;
    	    	    line = output + height * width;
    	    	}
    	    	
    	    	switch(opcode) {
    	    	    case 0:	// Fill
    	    	    	if(insertMix) {
    	    	    	    if(prevLine == 0) {
    	    	    	    	//setli(out, line, x, mix, 1);
    	    	    	    	out[line + x] = mix;
    	    	    	    }
    	    	    	    else {
    	    	    	    	//setli(out, line, x, getli(out, prevLine, x, 1) ^ mix, 1);
    	    	    	    	out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    	    	    }
    	    	    	    insertMix = false;
    	    	    	    count--;
    	    	    	    x++;
    	    		}
    	    		if(prevLine == 0) {
    	    		    // the original rdesktop C-Code uses an elegant define
    	    		    // for this while-loop which makes the code much shorter,
    	    		    // but we have to expand it here
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	/*for(i = 0; i < 8; i++) {
    	    		    	    setli(out, line, x, 0, 1);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    	*/
    	    		    	System.arraycopy(zeroes, 0, out, x + line, 8);
    	    		    	count -= 8;
    	    		    	x += 8;
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	/*setli(out, line, x, 0, 1);*/
    	    		    	out[line + x] = (byte) 0;
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    		else {
    	    		    oldX = x;
    	    		    loops = 0;
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	/*
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    //setli(out, line, x, getli(out, prevLine, x, 1), 1);
    	    		    	    out[line + x] = (byte) (out[prevLine + x] & 0xff);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    	*/
    	    		    	//System.arraycopy(out, prevLine + x, out, line + x, 8);
    	    		    	loops += 8;
    	    		    	x += 8;
    	    		    	count -= 8;
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	//setli(out, line, x, getli(out, prevLine, x, 1), 1);
    	    		    	//out[line + x] = out[prevLine + x];
    	    		    	count--;
    	    		    	x++;
    	    		    	loops++;
    	    		    }
    	    		    System.arraycopy(out, prevLine + oldX, out, line + oldX, loops);
    	    		}
    	    		break;
    	    	    case 1:	// Mix
    	    	    	if(prevLine == 0) {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	/*
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    //setli(out, line, x, mix, 1);
    	    		    	    out[line + x] = (byte) (mix & 0xff);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    	*/
    	    		    	out[line + x++] = mix;
    	    		    	out[line + x++] = mix;
    	    		    	out[line + x++] = mix;
    	    		    	out[line + x++] = mix;
    	    		    	out[line + x++] = mix;
    	    		    	out[line + x++] = mix;
    	    		    	out[line + x++] = mix;
    	    		    	out[line + x++] = mix;
    	    		    	count -= 8;
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	//setli(out, line, x, mix, 1);
    	    		    	out[line + x] = mix;
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    	    	}
    	    	    	else {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	/*
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    //setli(out, line, x, getli(out, prevLine, x, 1) ^ mix, 1);
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    	*/
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	out[line + x] = (byte) (out[prevLine + x++] ^ mix);
    	    		    	count -= 8;
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	//setli(out, line, x, getli(out, prevLine, x, 1) ^ mix, 1);
    	    		    	out[line + x] = (byte) (out[prevLine + x] ^ mix);
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    	    	}
    	    	    	break;
    	    	    case 2:	//Fill or Mix
    	    	    	if(prevLine == 0) {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	/*
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    mixMask <<= 1;
    	    		    	    mixMask &= 0xff;
    	    		    	    if (mixMask == 0) {
    	    		    	    	mask = (fomMask != 0) ? fomMask : cval(data, input++);
    	    		    	    	mixMask = 1;
    	    		    	    }
    	    		    	    if((mask & mixMask) != 0) {
    	    		    	    	//setli(out, line, x, mix, 1);
    	    		    	    	out[line + x] = (byte) (mix & 0xff);
    	    		    	    }
    	    		    	    else {
    	    		    	    	//setli(out, line, x, 0, 1);
    	    		    	    	//System.arraycopy(zeroes, 0, out, x * 1 + line, 1);
    	    		    	    	out[line + x] = (byte) 0;
    	    		    	    }

    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    	*/
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = (byte) 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = mix;
    	    		    	} else {
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	count -= 8;
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    //setli(out, line, x, mix, 1);
    	    		    	    out[line + x] = mix;
    	    		    	}
    	    		    	else {
    	    		    	    //setli(out, line, x, 0, 1);
    	    		    	    //System.arraycopy(zeroes, 0, out, x * 1 + line, 1);
    	    		    	    out[line + x] = (byte) 0;
    	    		    	}
    	    		    	
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    	    	}
    	    	    	else {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	/*
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    mixMask <<= 1;
    	    		    	    mixMask &= 0xff;
    	    		    	    if (mixMask == 0) {
    	    		    	    	mask = (fomMask != 0) ? fomMask : cval(data, input++);
    	    		    	    	mixMask = 1;
    	    		    	    }
    	    		    	    if((mask & mixMask) != 0) {
    	    		    	    	//setli(out, line, x, getli(out, prevLine, x, 1) ^ mix, 1);
    	    		    	    	out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	    }
    	    		    	    else {
    	    		    	    	//setli(out, line, x, getli(out, prevLine, x, 1), 1);
    	    		    	    	out[line + x] = (byte) (out[prevLine + x] & 0xff);
    	    		    	    }

    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    	*/
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	} else {
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	x++;
    	    		    	
    	    		    	count -= 8;
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	mixMask <<= 1;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : data[input++];
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    //setli(out, line, x, getli(out, prevLine, x, 1) ^ mix, 1);
    	    		    	    out[line + x] = (byte) ((out[prevLine + x] ^ mix) & 0xff);
    	    		    	}
    	    		    	else {
    	    		    	    //setli(out, line, x, getli(out, prevLine, x, 1), 1);
    	    		    	    out[line + x] = out[prevLine + x];
    	    		    	}
    	    		    	
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    	    	break;
    	    	    case 3:	// Color
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    /*
    	    		    for(i = 0; i < 8; i++) {
    	    		    	//setli(out, line, x, color2, 1);
    	    		    	out[line + x] = (byte) (color2 & 0xff);
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		    */
    	    		    out[line + x++] = color2;
    	    		    out[line + x++] = color2;
    	    		    out[line + x++] = color2;
    	    		    out[line + x++] = color2;
    	    		    out[line + x++] = color2;
    	    		    out[line + x++] = color2;
    	    		    out[line + x++] = color2;
    	    		    out[line + x++] = color2;
    	    		    count -= 8;
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    //setli(out, line, x, color2, 1);
    	    		    out[line + x] = color2;
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    case 4:	// Copy
    	    		oldX = x;
    	    		loops = 0;
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    /*
    	    		    for(i = 0; i < 8; i++) {
    	    		    	//setli(out, line, x, cvalx(data, input, 1), 1);
    	    		    	//input += 1;
    	    		    	out[line + x] = (byte) cval(data, input++);
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		    */
    	    		    count -= 8;
    	    		    x += 8;
    	    		    loops += 8;
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    //setli(out, line, x, cvalx(data, input, 1), 1);
    	    		    //input += 1;
    	    		    //out[line + x] = cvalb(data, input++);
    	    		    count--;
    	    		    x++;
    	    		    loops++;
    	    		}
    	    		System.arraycopy(data, input, out, line + oldX, loops);
    	    		input += loops;
    	    		break;
    	    	    case 8:	// Bicolor
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    /*
    	    		    for(i = 0; i < 8; i++) {
    	    		    	if(biColor) {
    	    		    	    //setli(out, line, x, color2, 1);
    	    		    	    out[line + x] = (byte) (color2 & 0xff);
    	    		    	    biColor = false;
    	    			}
    	    			else {
    	    			    //setli(out, line, x, color1, 1);
    	    			    out[line + x] = (byte) (color1 & 0xff);
    	    			    biColor = true;
				    count++;
    	    			}
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		    */
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		    if(biColor) {
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    } else {
    	    		    	out[line + x] = color1;
    	    		    	biColor = true;
    	    		    	count++;
    	    		    }
    	    		    x++; count--;
    	    		    
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    if(biColor) {
    	    		    	//setli(out, line, x, color2, 1);
    	    		    	out[line + x] = color2;
    	    		    	biColor = false;
    	    		    }
    	    		    else {
    	    			//setli(out, line, x, color1, 1);
    	    			out[line + x] = color1;
    	    			biColor = true;
				count++;
    	    		    }
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    case 0xd:	// white
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    /*for(i = 0; i < 8; i++) {
    	    		    	setli(out, line, x, 0xffffffff, 1);
    	    		    	count--;
    	    		    	x++;
    	    		    }*/
    	    		    System.arraycopy(ffs, 0, out, x + line, 8);
    	    		    count -= 8;
    	    		    x += 8;
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    //setli(out, line, x, 0xffffffff, 1);
    	    		    //System.arraycopy(ffs, 0, out, x * 1 + line, 1);
    	    		    out[line + x] = (byte) 0xff;
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    case 0xe:	// black
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    /*for(i = 0; i < 8; i++) {
    	    		    	setli(out, line, x, 0, 1);
    	    		    	count--;
    	    		    	x++;
    	    		    }*/
    	    		    System.arraycopy(zeroes, 0, out, x + line, 8);
    	    		    count -= 8;
    	    		    x += 8;
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    //setli(out, line, x, 0, 1);
    	    		    //System.arraycopy(zeroes, 0, out, x * 1 + line, 1);
    	    		    out[line + x] = (byte) 0;
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    default:
    	    	        System.out.println("RDP: BitmapDecompressor: wrong bitmap opcode: 0x" + Integer.toHexString(opcode));
    	    	        if(debug && false) {
    	    	            System.out.println("Bitmap data: width = " + inWidth + ", height = " + inHeight + ", size = " + size + ", data:");
    	    	            for(int j = 0; j < size - 1; j++) {
    	    	            	System.out.print("0x" + Integer.toHexString(data[j] & 0xff) + ", ");
    	    	            }
    	    	            System.out.println("0x" + Integer.toHexString(data[size - 1] & 0xff));
    	    	        }
    	    	        return null;
    	    	}
    	    }
    	}
    	
    	debug("RDP BitmapDecompressor: successfully decompressed bitmap");
    	
    	int outInt[] = getIntBuffer(inWidth * inHeight);
    	
    	colorTranslator.translateColor(outInt, 0, out, 0, inWidth * inHeight);
    	
    	return outInt;
    }

    // decompress an image
    public int[] decompress(byte data[], int width, int height, int size, int bpp) {
    	if(bpp == 1) {	// 8 bits/pixel
    	    return decompress8(data, width, height, size);
    	}
    	
    	byte[] out = getBuffer(width * height * bpp);
    	
    	int end = size;
    	int input = 0, output = 0;
    	int prevLine = 0, line = 0;
    	int opcode, count = 0, offset, x = width;
    	int lastOpcode = -1;
    	boolean insertMix = false, biColor = false, isFillOrMix = false;
	int code;
	int color1 = 0, color2 = 0;
	int mixMask, mask = 0;
	int mix = 0xffffffff;
	int fomMask = 0;
	
	int i;
	
	// debugging
	int inWidth = width;
	int inHeight = height;
    	
    	while(input < end) {
    	    fomMask = 0;
    	    code = cval(data, input++);
    	    opcode = code >> 4;
    	    
    	    // Handle different opcode forms
    	    switch(opcode) {
    	    	case 0xc:
    	    	case 0xd:
    	    	case 0xe:
    	    	    opcode -= 6;
    	    	    count = code & 0xf;
    	    	    offset = 16;
    	    	    break;
    	    	case 0xf:
    	    	    opcode = code & 0xf;
    	    	    if(opcode < 9) {
    	    	    	count = cval(data, input++);
    	    	    	count |= cval(data, input++) << 8;
    	    	    }
    	    	    else {
    	    	    	count = (opcode < 0xb) ? 8 : 1;
    	    	    }
    	    	    offset = 0;
    	    	    break;
    	    	default:
    	    	    opcode >>= 1;
		    count = code & 0x1f;
		    offset = 32;
		    break;
    	    }
    	    
    	    // Handle strange cases for counts
    	    if(offset != 0) {
    	    	isFillOrMix =  ((opcode == 2) || (opcode == 7));
    	    	if(count == 0) {
    	    	    if(isFillOrMix) {
    	    	    	count = cval(data, input++) + 1;
    	    	    }
    	    	    else {
    	    	    	count = cval(data, input++) + offset;
    	    	    }
    	    	}
    	    	else if(isFillOrMix) {
    	    	    count <<= 3;
    	    	}
    	    }
    	    
    	    // Read preliminary data
    	    switch(opcode) {
    	    	case 0:		// Fill
    	    	    if((lastOpcode == opcode) && !((x == width) && (prevLine == 0))) {
    	    	    	insertMix = true;
    	    	    }
    	    	    break;
    	    	case 8:		// Bicolor
    	    	    color1 = cvalx(data, input, bpp);
    	    	    input += bpp;
    	    	    // fall through
    	    	case 3:		// Color
    	    	    color2 = cvalx(data, input, bpp);
    	    	    input += bpp;
    	    	    break;
    	    	case 6:		// SetMix/Mix
    	    	case 7:		// SetMix/FillOrMix
    	    	    mix = cvalx(data, input, bpp);
    	    	    input += bpp;
    	    	    opcode -= 5;
    	    	    break;
    	    	case 9:		// FillOrMix_1
    	    	    mask = 0x3;
    	    	    opcode = 0x2;
    	    	    fomMask = 3;
    	    	    break;
    	    	case 0x0a:	// fillOrMix_2
    	    	    mask = 0x05;
    	    	    opcode = 0x02;
    	    	    fomMask = 5;
    	    	    break;
    	    }
    	    
    	    lastOpcode = opcode;
    	    mixMask = 0;
    	    
    	    // Output body
    	    while(count > 0) {
    	    	if(x >= width) {
    	    	    if(height <= 0) {
    	    	    	debug("RDP BitmapDecompressor: height <= 0");
    	    	    	return null;
    	    	    }
    	    	    
    	    	    x = 0;
    	    	    height--;
    	    	    
    	    	    prevLine = line;
    	    	    line = output + height * width * bpp;
    	    	}
    	    	
    	    	switch(opcode) {
    	    	    case 0:	// Fill
    	    	    	if(insertMix) {
    	    	    	    if(prevLine == 0) {
    	    	    	    	setli(out, line, x, mix, bpp);
    	    	    	    }
    	    	    	    else {
    	    	    	    	setli(out, line, x, getli(out, prevLine, x, bpp) ^ mix, bpp);
    	    	    	    }
    	    	    	    insertMix = false;
    	    	    	    count--;
    	    	    	    x++;
    	    		}
    	    		if(prevLine == 0) {
    	    		    // the original rdesktop C-Code uses a elegant define
    	    		    // for this while-loop which makes the code much shorter,
    	    		    // but we have to expand it here
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	/*for(i = 0; i < 8; i++) {
    	    		    	    setli(out, line, x, 0, bpp);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    	*/
    	    		    	System.arraycopy(zeroes, 0, out, x * bpp + line, 8 * bpp);
    	    		    	debug("using arraycopy");
    	    		    	count -= 8;
    	    		    	x += 8;
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	/*setli(out, line, x, 0, bpp);*/
    	    		    	System.arraycopy(zeroes, 0, out, x * bpp + line, bpp);
    	    		    	debug("using arraycopy");
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    		else {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    setli(out, line, x, getli(out, prevLine, x, bpp), bpp);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	setli(out, line, x, getli(out, prevLine, x, bpp), bpp);
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    		break;
    	    	    case 1:	// Mix
    	    	    	if(prevLine == 0) {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    setli(out, line, x, mix, bpp);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	setli(out, line, x, mix, bpp);
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    	    	}
    	    	    	else {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    setli(out, line, x, getli(out, prevLine, x, bpp) ^ mix, bpp);
    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	setli(out, line, x, getli(out, prevLine, x, bpp) ^ mix, bpp);
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    	    	}
    	    	    	break;
    	    	    case 2:	//Fill or Mix
    	    	    	if(prevLine == 0) {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    mixMask <<= 1;
    	    		    	    mixMask &= 0xff;
    	    		    	    if (mixMask == 0) {
    	    		    	    	mask = (fomMask != 0) ? fomMask : cval(data, input++);
    	    		    	    	mixMask = 1;
    	    		    	    }
    	    		    	    if((mask & mixMask) != 0) {
    	    		    	    	setli(out, line, x, mix, bpp);
    	    		    	    }
    	    		    	    else {
    	    		    	    	/*setli(out, line, x, 0, bpp);*/
    	    		    	    	System.arraycopy(zeroes, 0, out, x * bpp + line, bpp);
    	    		    	    	debug("using arraycopy");
    	    		    	    }

    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	mixMask <<= 1;
    	    		    	mixMask &= 0xff;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : cval(data, input++);
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    setli(out, line, x, mix, bpp);
    	    		    	}
    	    		    	else {
    	    		    	    /*setli(out, line, x, 0, bpp);*/
    	    		    	    System.arraycopy(zeroes, 0, out, x * bpp + line, bpp);
    	    		    	    debug("using arraycopy");
    	    		    	}
    	    		    	
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    	    	}
    	    	    	else {
    	    		    while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    	for(i = 0; i < 8; i++) {
    	    		    	    mixMask <<= 1;
    	    		    	    mixMask &= 0xff;
    	    		    	    if (mixMask == 0) {
    	    		    	    	mask = (fomMask != 0) ? fomMask : cval(data, input++);
    	    		    	    	mixMask = 1;
    	    		    	    }
    	    		    	    if((mask & mixMask) != 0) {
    	    		    	    	setli(out, line, x, getli(out, prevLine, x, bpp) ^ mix, bpp);
    	    		    	    }
    	    		    	    else {
    	    		    	    	setli(out, line, x, getli(out, prevLine, x, bpp), bpp);
    	    		    	    }

    	    		    	    count--;
    	    		    	    x++;
    	    		    	}
    	    		    }
    	    		    while((count > 0) && (x < width)) {
    	    		    	mixMask <<= 1;
    	    		    	mixMask &= 0xff;
    	    		    	if (mixMask == 0) {
    	    		    	    mask = (fomMask != 0) ? fomMask : cval(data, input++);
    	    		    	    mixMask = 1;
    	    		    	}
    	    		    	if((mask & mixMask) != 0) {
    	    		    	    setli(out, line, x, getli(out, prevLine, x, bpp) ^ mix, bpp);
    	    		    	}
    	    		    	else {
    	    		    	    setli(out, line, x, getli(out, prevLine, x, bpp), bpp);
    	    		    	}
    	    		    	
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    	    	break;
    	    	    case 3:	// Color
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    for(i = 0; i < 8; i++) {
    	    		    	setli(out, line, x, color2, bpp);
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    setli(out, line, x, color2, bpp);
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    case 4:	// Copy
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    for(i = 0; i < 8; i++) {
    	    		    	setli(out, line, x, cvalx(data, input, bpp), bpp);
    	    		    	input += bpp;
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    setli(out, line, x, cvalx(data, input, bpp), bpp);
    	    		    input += bpp;
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    case 8:	// Bicolor
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    for(i = 0; i < 8; i++) {
    	    		    	if(biColor) {
    	    		    	    setli(out, line, x, color2, bpp);
    	    		    	    biColor = false;
    	    			}
    	    			else {
    	    			    setli(out, line, x, color1, bpp);
    	    			    biColor = true;
				    count++;
    	    			}
    	    		    	count--;
    	    		    	x++;
    	    		    }
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    if(biColor) {
    	    		    	setli(out, line, x, color2, bpp);
    	    		    	biColor = false;
    	    		    }
    	    		    else {
    	    			setli(out, line, x, color1, bpp);
    	    			biColor = true;
				count++;
    	    		    }
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    case 0xd:	// white
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    /*for(i = 0; i < 8; i++) {
    	    		    	setli(out, line, x, 0xffffffff, bpp);
    	    		    	count--;
    	    		    	x++;
    	    		    }*/
    	    		    System.arraycopy(ffs, 0, out, x * bpp + line, 8 * bpp);
    	    		    debug("using arraycopy");
    	    		    count -= 8;
    	    		    x += 8;
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    /*setli(out, line, x, 0xffffffff, bpp);*/
    	    		    System.arraycopy(ffs, 0, out, x * bpp + line, bpp);
    	    		    debug("using arraycopy");
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    case 0xe:	// black
    	    		while(((count & ~0x7) != 0) && ((x + 8) < width)) {
    	    		    /*for(i = 0; i < 8; i++) {
    	    		    	setli(out, line, x, 0, bpp);
    	    		    	count--;
    	    		    	x++;
    	    		    }*/
    	    		    System.arraycopy(zeroes, 0, out, x * bpp + line, 8 * bpp);
    	    		    debug("using arraycopy");
    	    		    count -= 8;
    	    		    x += 8;
    	    		}
    	    		while((count > 0) && (x < width)) {
    	    		    /*setli(out, line, x, 0, bpp);*/
    	    		    System.arraycopy(zeroes, 0, out, x * bpp + line, bpp);
    	    		    debug("using arraycopy");
    	    		    count--;
    	    		    x++;
    	    		}
    	    		break;
    	    	    default:
    	    	        System.out.println("RDP: BitmapDecompressor: wrong bitmap opcode: 0x" + Integer.toHexString(opcode));
    	    	        if(debug && false) {
    	    	            System.out.println("Bitmap data: width = " + inWidth + ", height = " + inHeight + ", size = " + size + ", data:");
    	    	            for(int j = 0; j < size - 1; j++) {
    	    	            	System.out.print("0x" + Integer.toHexString(data[j] & 0xff) + ", ");
    	    	            }
    	    	            System.out.println("0x" + Integer.toHexString(data[size - 1] & 0xff));
    	    	        }
    	    	        return null;
    	    	}
    	    }
    	}
    	
    	debug("RDP BitmapDecompressor: successfully decompressed bitmap");
    	
    	int outInt[] = getIntBuffer(inWidth * inHeight);
    	
    	colorTranslator.translateColor(outInt, 0, out, 0, inWidth * inHeight);
    	
    	return outInt;
    }

}
