package nn.pp.rcrdp;

import java.awt.*;

public class Blitter {

    private boolean debug = false;
    
    private int sImgMem[] = null;
    private Dimension mysize;
    
    // debugging
    private void debug(String s) {
    	if(debug) System.out.println(s);
    }
    
    public void setImageArray(int sImgMem[]) {
    	this.sImgMem = sImgMem;
    }
    
    public void setRenderSize(Dimension d) {
    	mysize = d;
    }
    
    // do a clear (0) blit
    private void clearBlit(int x, int y, int cx, int cy) {
    	int imgMem[] = sImgMem;	// it is faster to access a local variable here
    	int w = mysize.width;
    	int indexDst;	// it is faster if we don't calculate the array offset in each loop
    	
    	indexDst = y * w + x;

    	for(int i = 0; i < cy; i++) {
    	    for(int j = 0; j < cx; j++) {
    	    	// the alpha channel must always be set to be solid, the rest cleared
    	    	imgMem[indexDst++] = 0xff000000;
    	    }
    	    indexDst += w - cx;
    	}
    }
    
    // a nor (NOT src AND NOT dst) blit
    private void norBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;	// source color
    	int cd;	// destination color
    	int indexSrc, indexDst;

    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);

    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (~cs & ~cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a and inverted (NOT src AND dst) blit
    private void andInvertedBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;

    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);

    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (~cs & cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a copy inverted (NOT src) blit
    private void copyInvertedBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int indexSrc, indexDst;

    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);

    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	imgMem[indexDst++] = ~cs | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a and reverse (src AND NOT dst) blit
    private void andReverseBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;

    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);

    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (cs & ~cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a invert (NOT dst) blit
    private void invertBlit(int x, int y, int cx, int cy) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cd;
    	int indexDst;

    	indexDst = y * w + x;

    	for(int i = 0; i < cy; i++) {
    	    for(int j = 0; j < cx; j++) {
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = ~cd | 0xff000000;
    	    }
    	    indexDst += w - cx;
    	}
    }
    
    // a xor (src XOR dst) blit
    private void xorBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;

    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);

    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (cs ^ cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a nand (NOT src OR NOT dst) blit
    private void nandBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;

    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);

    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (~cs | ~cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a and (src AND dst) blit
    private void andBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;
    	
    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);
    	
    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (cs & cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a equiv (NOT src XOR dst) blit
    private void equivBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;
    	
    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);
    	
    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (~cs ^ cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a or inverted (NOT src OR dst) blit
    private void orInvertedBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;
    	
    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);
    	
    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (~cs | cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // do a copy blit into our MemoryImageSource int array
    private void copyBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;

    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);
    	
    	int indexSrc = srcScan * srcY + srcX;
    	int indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    System.arraycopy(src, indexSrc, imgMem, indexDst, minX);
    	    indexSrc += srcScan;
    	    indexDst += w;
    	}
    }
    
    // a or reverse (src OR NOT dst) blit
    private void orReverseBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;
    	
    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);
    	
    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (cs | ~cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // a or (src OR dst) blit
    private void orBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int cs;
    	int cd;
    	int indexSrc, indexDst;
    	
    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);
    	
    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	cs = src[indexSrc++];
    	    	cd = imgMem[indexDst];
    	    	imgMem[indexDst++] = (cs | cd) | 0xff000000;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }
    
    // do a set (1) blit
    private void setBlit(int x, int y, int cx, int cy) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int indexDst;
    	
    	indexDst = y * w + x;

    	for(int i = 0; i < cy; i++) {
    	    for(int j = 0; j < cx; j++) {
    	    	imgMem[indexDst++] = 0xffffffff;
    	    }
    	    indexDst += w - cx;
    	}
    }
    
    // do a transparent blit into our MemoryImageSource int array
    private void transparentBlit(int src[], int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan, int bgColor) {
    	int imgMem[] = sImgMem;
    	int w = mysize.width;
    	int indexSrc, indexDst;
    	
    	int minY = Math.min(cy, srcCy);
    	int minX = Math.min(cx, srcCx);
    	
    	indexSrc = srcY * srcScan + srcX;
    	indexDst = y * w + x;
    	
    	for(int i = 0; i < minY; i++) {
    	    for(int j = 0; j < minX; j++) {
    	    	if(src[indexSrc] != bgColor) {
    	    	    imgMem[indexDst] = src[indexSrc];
    	    	}
    	    	indexDst++;
    	    	indexSrc++;
    	    }
    	    indexSrc += srcScan - minX;
    	    indexDst += w - minX;
    	}
    }

    // a generic blit method; you only should call this directly, not the others above!
    public void blit(int src[], int opcode, int x, int y, int cx, int cy, int srcX, int srcY, int srcCx, int srcCy, int srcScan, int bgColor) {
    	switch(opcode) {
    	    case RDPConstants.rdpBlitClear:
    	    	//debug("RDP RDPRenderer: using clearBlit");
    	    	clearBlit(x, y, cx, cy);
    	    	break;
    	    case RDPConstants.rdpBlitNor:
    	    	//debug("RDP RDPRenderer: using norBlit");
    	    	norBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitAndInverted:
    	    	//debug("RDP RDPRenderer: using andInvertedBlit");
    	    	andInvertedBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitCopyInverted:
    	    	//debug("RDP RDPRenderer: using copyInvertedBlit");
    	    	copyInvertedBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitAndReverse:
    	    	//debug("RDP RDPRenderer: using andReverseBlit");
    	    	andReverseBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitInvert:
    	    	//debug("RDP RDPRenderer: using invertBlit");
    	    	invertBlit(x, y, cx, cy);
    	    	break;
    	    case RDPConstants.rdpBlitXor:
    	    	//debug("RDP RDPRenderer: using xorBlit");
    	    	xorBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitNand:
    	    	//debug("RDP RDPRenderer: using nandBlit");
    	    	nandBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitAnd:
    	    	//debug("RDP RDPRenderer: using andBlit");
    	    	andBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitEquiv:
    	    	//debug("RDP RDPRenderer: using equivBlit");
    	    	equivBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitNoop:
    	    	//debug("RDP RDPRenderer: using noopBlit (nothing)");
    	    	// nothing to do here
    	    	break;
    	    case RDPConstants.rdpBlitOrInverted:
    	    	//debug("RDP RDPRenderer: using orInvertedBlit");
    	    	orInvertedBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitCopy:
    	    	//debug("RDP RDPRenderer: using copyBlit");
    	    	copyBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitOrReverse:
    	    	//debug("RDP RDPRenderer: using orReverseBlit");
    	    	orReverseBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitOr:
    	    	//debug("RDP RDPRenderer: using orBlit");
    	    	orBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan);
    	    	break;
    	    case RDPConstants.rdpBlitSet:
    	    	//debug("RDP RDPRenderer: using setBlit");
    	    	setBlit(x, y, cx, cy);
    	    	break;
    	    // this opcode doesn't come directly from the RDP server,
    	    // but it might be useful to implement it here
    	    case RDPConstants.rdpBlitTransparent:
    	    	//debug("RDP RDPRenderer: using transparentBlit");
    	    	transparentBlit(src, x, y, cx, cy, srcX, srcY, srcCx, srcCy, srcScan, bgColor);
    	    	break;
    	    default:
    	    	System.out.println("RDP RDPRenderer blit: unimplemented blitting opcode");
    	    	return;
    	}
    }
    
}
