package nn.pp.rcrdp;

import java.awt.*;
import java.awt.image.*;
import java.lang.reflect.*;

class RDPCursor {
    private Cursor cursor;
    
    private static RDPCursor clearCursor;
    
    private static int cursorNo = 0;
    
    private static Toolkit kit = Toolkit.getDefaultToolkit();
    
    public Cursor getCursor() {
    	return cursor;
    }
    
    public static RDPCursor getClearCursor() {
    	if(clearCursor == null) {
    	    clearCursor = new RDPCursor();
    	}
    	return clearCursor;
    }
    
    // an empty cursor
    // this is only used in getClearCursor()
    private RDPCursor() {
    	int m[] = new int[1];
    	m[0] = 0;

    	MemoryImageSource memImgSrc = new MemoryImageSource(1, 1, m, 0, 1);
    	Image memImg = kit.createImage(memImgSrc);
    	
    	cursor = kit.createCustomCursor(memImg, new Point(0, 0), "RDPClearCursor");
    }
    
    public RDPCursor(int spotX, int spotY, int width, int height, byte andMask[], byte xorMask[]) {
    	int indexAnd = 0;
    	int indexXor = 0;
    	int nextBit = 0x80;
    	int memImgInt[] = new int[width * height];
    	MemoryImageSource memImgSrc = new MemoryImageSource(width, height, memImgInt, 0, width);
    	int r, g, b, a;
    	
    	for(int i = 0; i < height; i++) {
    	    for(int j = 0; j < width; j++) {
    	    	r = xorMask[indexXor++] & 0xff;
    	    	g = xorMask[indexXor++] & 0xff;
    	    	b = xorMask[indexXor++] & 0xff;
    	    	a = andMask[indexAnd] & 0xff;
    	        if((a & nextBit) == 0) {
    	            a = 0xff;
    	        }
    	        else {
    	            a = 0;
    	        }
    	        // the text cursor is completely transparent, this doesn't make sense
    	        if(a == 0 && (r != 0 || g != 0 || b != 0)) {
    	            a = 0xff;
    	            r = g = b = 0;
    	        }
    	        nextBit >>= 1;
    	        if(nextBit == 0) {
    	            nextBit = 0x80;
    	            indexAnd++;
    	        }
    	        memImgInt[(height - 1 - i) * width + j] = (a << 24) | (r << 16) | (g << 8) | b;
    	    }
    	}
    	
    	Image memImg = kit.createImage(memImgSrc);

    	cursor = kit.createCustomCursor(memImg, new Point(spotX, spotY), "RDPCursor" + cursorNo++);
    }
}
