package nn.pp.rcrdp;

class RDPFontGlyph {
    private boolean debug = true;
    
    private void debug(String s) {
    	if(debug) System.out.println(s);
    }
    
    private byte[] pixMap = null;
    private int offset;
    private int baseLine;
    private int width;
    private int height;
    
    public RDPFontGlyph() {
    	pixMap = null;
    }
    
    public RDPFontGlyph(int offset, int baseLine, int width, int height, byte[] pixMap) {
    	this.offset = offset;
    	this.baseLine = baseLine;
    	this.width = width;
    	this.height = height;
    	this.pixMap = new byte[width * height];
    	
    	for(int y = 0; y < height; y++) {
    	    for(int x = 0; x < width; x++) {
    	    	int b = x / 8 + (y * ((width + 7) / 8));
    	    	b = pixMap[b];
    	    	b = (b << (x & 7)) & 0x80;
    	    	this.pixMap[y * width + x] = (b == 0) ? (byte) 0 : (byte) 1;
    	    }
    	}
    }
    
    public void showGlyph() {
    	debug("RDP RDPFontGlyph: width = " + width + ", height = " + height + ", len = " + pixMap.length);
    	if(debug) {
    	    for(int i = 0; i < pixMap.length; i++) System.out.print("0x" + Integer.toHexString(pixMap[i] & 0xff) + " ");
    	    System.out.println();
    	    for(int y = 0; y < height; y++) {
    	    	for(int x = 0; x < width; x++) {
    	    	    if(this.pixMap[y * width + x] == 0) System.out.print(" ");
    	    	    else System.out.print("x");
    	    	}
    	    	System.out.println();
    	    }
    	}
    }
    
    public byte[] getPixMap() {
    	return pixMap;
    }
    
    public int getOffset() {
    	return offset;
    }
    
    public int getBaseLine() {
    	return baseLine;
    }
    
    public int getWidth() {
    	return width;
    }
    
    public int getHeight() {
    	return height;
    }
}
