package nn.pp.rcrdp;

import java.io.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import nn.pp.rc.*;
import nn.pp.rckbd.*;

/**
 * The RDPHandler is the actual protocoll handler running
 * the RDP protocoll.
 *
 * It makes use of two Co-classes:
 * RDPProto:    is the low level, message oriented network stuff
 * RDPRenderer: is a polymorphic class depending on the actual
 *              client capabilities and higher level protocoll
 *              parameters responsible to bring the bits on the screen
 *
 * RDPHandler is a thread and should be started as such
 */
public class RDPHandler
    extends RCHandler {

    public boolean fps   = false;

    RDPProto           rdpProto;
    RFBproto           rfbProto;
    RFBHandler         rfbHandler;
    RDPRenderer        rdr;
    RDPProfile         rdpProfile;
    Cache              cache;
    
    private int kbdLayout;

    public RDPHandler (ServerConsolePanelBase scp, RCCanvasPanel canvas,
		       TrafficMonitor tmoni, PrintStream logger,
		       RFBProfile profile, Dimension dimension,
		       Locale kbdLocale, RFBHandler rfbHandler) {
	super(scp, canvas, null, tmoni, null, null, null, logger, profile);

	mhandler1 = new MouseHandlerRDP(scp);
	
	this.rfbHandler = rfbHandler;
	this.rfbProto = rfbHandler.getRFBProto();
	
	rdr = loadRDPRenderer(canvas);
	rdr.setRenderSize(dimension);
	
	setKbdLocale(kbdLocale);
	
	rdpProfile = new RDPProfile();
	rdpProfile.isJ14 = JVMVersionInfo.getJVMVersionInfo().isJava14();

	cache = new Cache();

	rdr.setProfile(rdpProfile);
	rdr.setCache(cache);
	
	proto = rdpProto = new RDPProto(this, rdpProfile, rdr, cache, logger,
					canvas, dimension.width,
					dimension.height, kbdLayout,
					profile.rdpUser);
    }
    
    public void switchFPS() {
    	super.switchFPS();
    	rdpProto.switchFPS();
    }

    public RCRenderer getRenderer() {
    	return rdr;
    }
    
    public void setScreenSize(int w, int h) {
    	rdpProto.setSize(w, h);
    	if(!proto.connected()) rdr.setRenderSize(new Dimension(w, h));
    }
    
    public void setKbdLocale(Locale locale) {
	String s = locale.toString();
	if(s.length() == 0) {
	    return;
	}
	if(s.equals("en") || s.equals("en_UK")) {
	    kbdLayout = RDPConstants.kbdLayoutEnUK;
	}
	else if(s.equals("en_US")) {
	    kbdLayout = RDPConstants.kbdLayoutEnUS;
	}
	else if(s.substring(0, 2).equals("de")) {
	    kbdLayout = RDPConstants.kbdLayoutDe;
	}
	else if(s.substring(0, 2).equals("fr")) {
	    kbdLayout = RDPConstants.kbdLayoutFr;
	}
	else if(s.substring(0, 2).equals("it")) {
	    kbdLayout = RDPConstants.kbdLayoutIt;
	}
	else if(s.substring(0, 2).equals("es")) {
	    kbdLayout = RDPConstants.kbdLayoutEs;
	}
	else if(s.substring(0, 2).equals("pt")) {
	    kbdLayout = RDPConstants.kbdLayoutPt;
	}
	else if(s.substring(0, 2).equals("ru")) {
	    kbdLayout = RDPConstants.kbdLayoutRu;
	}
	else if(s.substring(0, 2).equals("fi")) {
	    kbdLayout = RDPConstants.kbdLayoutFi;
	}
	else if(s.substring(0, 2).equals("sv")) {
	    kbdLayout = RDPConstants.kbdLayoutSv;
	}
	else if(s.substring(0, 2).equals("da")) {
	    kbdLayout = RDPConstants.kbdLayoutDa;
	}
	else {
	    kbdLayout = RDPConstants.kbdLayoutEnUS;	// default is en_US
	}
	
	if(rdpProto != null) rdpProto.setKbdKayout(kbdLayout);
    }

    protected void showQuitMsg(int q) {
    	logger.println(T._("RDP: terminated"));
    }
    
    protected void disposeConnect() {
    	dispose();
    }

    protected void dispose() {
	rdpProto.dispose();
	try {
    	    rfbProto.writeRCModeRequest(RFBproto.RDPLeave);
    	} catch (IOException ignore) {  }
    	rdr.dispose();
    	scp.disconnected(this);
    }

    protected void establishConnection() throws IOException {
    	String password;
    	if(profile.rdpPassword == null) {
    	    password = "";
    	}
    	else {
    	    password = profile.rdpPassword;
    	}
    	int flags = RDPConstants.rdpLogonNormal;
    	if(password.length() > 0) {
    	    flags |= RDPConstants.rdpLogonAuto;
    	}
    	rdpProto.connect(profile.remoteHost, // host
    	                 profile.rdpPort,    // port
    	                 flags,              // flags
    	                 "",                 // domain
    	                 password,           // password
    	                 "",                 // command/shell
    	                 ""                  // directory
    	                 );
    }
    
    public void distributeProto() {
    	mhandler1.setRCProto(proto);
    	tmoni.setStreams(rdpProto.getTCPLayer(), rdpProto.getTCPLayer());
    	canvas.setRCHandler(this);
	logger.println(canvas);
    }

    protected void writeKeyboardEvent(byte keycode) throws IOException {
	rdpProto.writeKeyboardEvent(keycode);
    }

    protected void writeKvmSwitchEvent(short newport) throws IOException {
	//rdpProto.writeKvmSwitchEvent(newport);
    }
    
    protected int processProtocol() throws IOException {
    	rdpProto.mainLoop();
    	return 0;
    }
    
    private RDPRenderer loadRDPRenderer(Component scc) {
	RDPRenderer r;
	if(JVMVersionInfo.getJVMVersionInfo().isJava14()) {
	    r = new RDPRendererJ14(scc);
	} else {
	    r = new RDPRendererJ11(scc);
	}
	return r;
    }

    protected String mode() {
    	return T._("RDP");
    }

    public String toString() {
	if(proto == null) {
	    return T._("not connected");
	}
	return T._("RDP");
    }
}
