package nn.pp.rcrdp.crypto;

import java.security.*;

public abstract class BlockMessageDigest {

    protected MessageDigest digest = null;
    
    public void engineUpdate(byte in[]) {
    	digest.update(in);
    }   
    
    public void engineUpdate(byte in[], int len) {
    	digest.update(in, 0, len);
    }

    public void engineUpdate(byte in[], int offset, int len) {
    	digest.update(in, offset, len);
    }

    public byte[] engineDigest() {
    	return digest.digest();
    }
}
