package nn.pp.rcsoftkbd;

import java.awt.*;
import java.util.*;
import java.io.*;
import java.net.*;
import nn.pp.rcsoftkbd.*;
import nn.pp.rckbd.*;

public abstract class KbdMapping
{	
    private Hashtable         htmodifier = new Hashtable();
    private Hashtable         imghash    = new Hashtable(5);
    private MappingPrefs      MappingPrefs = new MappingPrefs();
		
    protected abstract MapDef[] getMapDefs(Short modifier);
    protected abstract String getKeyImgName(Short modifier);
    protected abstract void getMappingPrefs(MappingPrefs prefs);    
    public abstract short getKeyImgHeight();
    public abstract Locale getLocale();
    
    class MappingPrefs {
        public short            ImageWidth;
        public short            ImageExtWidth;
        public short            ImageThreshold;
    }

    public KbdMapping() {
        getMappingPrefs(MappingPrefs);
    }

    public int getImageXPos(int ImageIdx)
    {
        if ((ImageIdx < MappingPrefs.ImageThreshold) || (MappingPrefs.ImageThreshold == 0)) {
            return ImageIdx * MappingPrefs.ImageWidth;
        } else {
            return MappingPrefs.ImageThreshold * MappingPrefs.ImageWidth + 
                   (ImageIdx - MappingPrefs.ImageThreshold) * MappingPrefs.ImageExtWidth;
        }
    }

    public Image getKeyImg(Short mod) {
	Image img = null;
	String imgname = getKeyImgName(mod);
	if((null != imgname) && (null == (img = (Image)imghash.get(imgname)))){
	    // netscape and microsoft hack, arghhh
	    String jvd = System.getProperty("java.vendor");
	    String jvs = System.getProperty("java.version");
	    //System.out.println("vender=" + jvd + " version=" + jvs);
	    if(jvs.startsWith("1.1") 
	       && (jvd.startsWith("Netscape") || jvd.startsWith("IBM"))) {
		img = getImageOldJava(imgname);
	    } else if (jvs.startsWith("3.1")) {	// PJava
		if (KbdFactory.applet_codebase != null) {
		    try {
		    	URL imurl = new URL(KbdFactory.applet_codebase, "/" + imgname);
		    	img = Toolkit.getDefaultToolkit().getImage(imurl);
		    } catch (MalformedURLException e) {};
		}
	    } else { // all others hopefully work as specified
		URL imurl = getClass().getClassLoader().getResource(imgname); 
		img = Toolkit.getDefaultToolkit().getImage(imurl);
	    }
	    if(img != null) imghash.put(imgname, img);
	}
	return img;
    }
	
    public boolean hasMapping(Short modifier){
 	if (getMapDefs(modifier) == null) return false;
	else return true;
    }
	
    public String getKeyChar(Short keynumber, Short mod){
 	Hashtable htkey = loadKeyTable(mod);
	MapDef map = getMapDef(keynumber, mod);
	if (map != null) {
	    return map.keychar;
	}
	return null;
    }
        
    public MapDef getMapDef(Short keynumber, Short mod){
 	Hashtable htkey=loadKeyTable(mod);
	MapDef map=(MapDef) htkey.get(keynumber);
	//if(map==null) map=new MapDef(keynumber.shortValue()," ",-1);
    	return map;
    } 
                  
    public short getKeyImgIdx(Short keynumber, Short modifier){
 	Hashtable htkey=loadKeyTable(modifier);
	MapDef map=(MapDef)htkey.get(keynumber);
	return map.imgidx;	
    }
	
    private Hashtable loadKeyTable(Short modifier){
 	if (!hasMapping(modifier)) 
	    return null;//throw new Exception("modifier not found");
	Hashtable htkey= new Hashtable();
	if(null == (htkey = (Hashtable) htmodifier.get(modifier))) 
	    htkey = create_hashmap_for(modifier);
	return htkey;
    }
	
    private Hashtable create_hashmap_for(Short modifier){
	Hashtable hash=new Hashtable();
	MapDef[] map = getMapDefs(modifier);
	for(int i=0; i<map.length; i++)
	    {
	  	hash.put(new Short(map[i].keynr),map[i]);	
	    }	
	htmodifier.put(modifier,hash);	
	return hash;
    }	

    /**
     * workaround for netscape's lack of resource support,
     * i.e. netscape can't load resources out of jar-files
     * this is netscapes suggestion how to deal with that
     */
    private Image getImageOldJava(String imgname) {
	Image img = null;
	try {
	    InputStream in;
	    in = getClass().getClassLoader().getResourceAsStream(imgname); 
	    if(null == in) return null;
	    byte[] buffer = new byte[in.available()]; 
	    in.read(buffer); 
	    img = Toolkit.getDefaultToolkit().createImage(buffer); 
	} catch (java.io.IOException e) { 
	    System.err.println("KbdMapping: getResImage: " + e); 
	}
	return img;
    }	
}	
