package nn.pp.rcsoftkbd;

import nn.pp.rckbd.*;
import java.util.*;

public class KbdMapping_de extends KbdMapping
{
    static private MapDef[] map_norm = {
	new MapDef(0,"^"),
	new MapDef(1,"1"),
	new MapDef(2,"2"),
	new MapDef(3,"3"),
	new MapDef(4,"4"),
	new MapDef(5,"5"),
	new MapDef(6,"6"),
	new MapDef(7,"7"),
	new MapDef(8,"8"),
	new MapDef(9,"9"),
	new MapDef(10,"0"),
	new MapDef(11,"\u00df"),
	new MapDef(12,"'"),
	new MapDef(13,"Backspace",1),	//back
  
	new MapDef(14,"Tab",4),	//Tab
	new MapDef(15,"q"),
	new MapDef(16,"w"),
	new MapDef(17,"e"),
	new MapDef(18,"r"),
	new MapDef(19,"t"),
	new MapDef(20,"z"),
	new MapDef(21,"u"),
	new MapDef(22,"i"),
	new MapDef(23,"o"),
	new MapDef(24,"p"),
	new MapDef(25,"\u00fc"),	//
	new MapDef(26,"+"),
	new MapDef(27,"Enter",0),	//return
  
	new MapDef(28,"Caps",2),	//Caps
	new MapDef(29,"a"),
	new MapDef(30,"s"),
	new MapDef(31,"d"),
	new MapDef(32,"f"),
	new MapDef(33,"g"),
	new MapDef(34,"h"),
	new MapDef(35,"j"),
	new MapDef(36,"k"),
	new MapDef(37,"l"),
	new MapDef(38,"\u00f6"),	//
	new MapDef(39,"\u00e4"),	//
	new MapDef(40,"#"),
  
	new MapDef(41,"Shift",3),	//Shift
	new MapDef(42,"<"),
	new MapDef(43,"y"),
	new MapDef(44,"x"),
	new MapDef(45,"c"),
	new MapDef(46,"v"),
	new MapDef(47,"b"),
	new MapDef(48,"n"),
	new MapDef(49,"m"),
	new MapDef(50,","),
	new MapDef(51,"."),
	new MapDef(52,"-"),
	new MapDef(53,"Shift",3),	//Shift
  
	new MapDef(54,"Strg"),
	new MapDef(55,"Alt"),
	new MapDef(56," "),
	new MapDef(57,"AltGr"),
	new MapDef(58,"Strg"),
  
	new MapDef(59,"Esc"),
	new MapDef(60,"F1"),
	new MapDef(61,"F2"),
	new MapDef(62,"F3"),
	new MapDef(63,"F4"),
	new MapDef(64,"F5"),
	new MapDef(65,"F6"),
	new MapDef(66,"F7"),
	new MapDef(67,"F8"),
	new MapDef(68,"F9"),
	new MapDef(69,"F10"),
	new MapDef(70,"F11"),
	new MapDef(71,"F12"),
  
	new MapDef(72,"Prn"),
	new MapDef(73,"Scroll",13),	//Scroll
	new MapDef(74,"Pau"),
  
	new MapDef(75,"Is"),
	new MapDef(76,"Pos1",11),	//Home
	new MapDef(77,"Bild Auf",9),	//PgUp
	new MapDef(78,"Del"),
	new MapDef(79,"End"),
	new MapDef(80,"Bild Ab",10),  	//PgDn
  
	new MapDef(81,"Auf",5),	//Up
	new MapDef(82,"Links",7),	//Left
	new MapDef(83,"Ab",6),	//Down
	new MapDef(84,"Rechts",8),	//Right
  
	new MapDef(85,"Num",12),	//Num
	new MapDef(86,"Pos1",11),	//home
	new MapDef(87,"Auf",5),	//Up
	new MapDef(88,"Bild Auf",9),	//PgUp
	new MapDef(89,"+"),
  
	new MapDef(90,"/"),  
	new MapDef(91,"Links",7),	//Left
	new MapDef(92,"5"),
	new MapDef(93,"Rechts",8),	//Right
  
	new MapDef(94,"*"),
	new MapDef(95,"End"),	
	new MapDef(96,"Ab",6),	//Down
	new MapDef(97,"Bild Ab",10),	//PgDn
	new MapDef(98,"Enter",0),	//NumRet
  
	new MapDef(99,"-"),
	new MapDef(100,"Ins"),
	new MapDef(101,"De"),
  
	new MapDef(102,"Strg"),
	new MapDef(103,"Alt"),
	new MapDef(104,"Reset"),
	new MapDef(105,"St"),
	new MapDef(106,"Me"),
	new MapDef(107,"St"),
	new MapDef(KeyDef.PAGE,"Page"),
	new MapDef(KeyDef.POPUP,"Menu"),
  
  
    };
 
    static private MapDef[] map_shift = {
	new MapDef(0,""),
	new MapDef(1,"!"),
	new MapDef(2,"\""),
	new MapDef(3,""),
	new MapDef(4,"$"),
	new MapDef(5,"%"),
	new MapDef(6,"&"),
	new MapDef(7,"/"),
	new MapDef(8,"("),
	new MapDef(9,")"),
	new MapDef(10,"="),
	new MapDef(11,"?"),
	new MapDef(12,"`"),
    
	new MapDef(15,"Q"),
	new MapDef(16,"W"),
	new MapDef(17,"E"),
	new MapDef(18,"R"),
	new MapDef(19,"T"),
	new MapDef(20,"Z"),
	new MapDef(21,"U"),
	new MapDef(22,"I"),
	new MapDef(23,"O"),
	new MapDef(24,"P"),
	new MapDef(25,"\u00dc"),		//
	new MapDef(26,"*"),
  
	new MapDef(29,"A"),
	new MapDef(30,"S"),
	new MapDef(31,"D"),
	new MapDef(32,"F"),
	new MapDef(33,"G"),
	new MapDef(34,"H"),
	new MapDef(35,"J"),
	new MapDef(36,"K"),
	new MapDef(37,"L"),
	new MapDef(38,"\u00d6"),		//
	new MapDef(39,"\u00c4"),		//
	new MapDef(40,"'"),
  
	new MapDef(42,">"),
	new MapDef(43,"Y"),
	new MapDef(44,"X"),
	new MapDef(45,"C"),
	new MapDef(46,"V"),
	new MapDef(47,"B"),
	new MapDef(48,"N"),
	new MapDef(49,"M"),
	new MapDef(50,";"),
	new MapDef(51,":"),
	new MapDef(52,"_"),
    };
 
    static private MapDef[] map_altgr = {
	new MapDef(2,""),
	new MapDef(3,""),
	new MapDef(7,"{"),
	new MapDef(8,"["),
	new MapDef(9,"]"),
	new MapDef(10,"}"),
	new MapDef(11,"\\"),
	new MapDef(15,"@"),
	new MapDef(17,"EUR",20), 		//   
	new MapDef(26,"~"),
	new MapDef(42,"|"),
	new MapDef(49,""),
    };
 
    static private MapDef[] map_num = {
	new MapDef(86,"7"),
	new MapDef(87,"8"),
	new MapDef(88,"9"),
  
	new MapDef(91,"4"),
	new MapDef(93,"6"),
  
	new MapDef(95,"1"),
	new MapDef(96,"2"),
	new MapDef(97,"3"),
  
	new MapDef(100,"0"),
	new MapDef(101,","),
    };
 
 
    protected MapDef[] getMapDefs(java.lang.Short mod)
    {
	switch (mod.shortValue())
	    {
	      case KeyDef.NOP: return map_norm;
	      case 53: return map_shift;
	      case 41: return map_shift;
	      case 28: return map_shift;
	      case 57: return map_altgr;
	      case 85: return map_num;
	      default: return null;
	    } 
    }
 
    protected String getKeyImgName(java.lang.Short mod)
    {
	switch (mod.shortValue())  {
	  case KeyDef.NOP: return "nn/pp/rcsoftkbd/germannorm.gif";
	  default: return null;
	} 	
    }	
 
    protected void getMappingPrefs(MappingPrefs prefs)
    {
        prefs.ImageWidth = 12;
        prefs.ImageExtWidth = 12;
        prefs.ImageThreshold = 0;
    } 
 
    public short getKeyImgHeight()
    {
	return 12;
    } 
 
    public Locale getLocale()
    {
	return Locale.GERMANY;
    }
 
 
}
