package nn.pp.rcsoftkbd;

import nn.pp.rckbd.*;
import java.util.*;

public class KbdMapping_ja extends KbdMapping
{
 static private MapDef[] map_norm = {
  new MapDef(0, null, 63),
  new MapDef(1,null,14),
  new MapDef(2,null,15),
  new MapDef(3,null,16),
  new MapDef(4,null,17),
  new MapDef(5,null,18),
  new MapDef(6,null,19),
  new MapDef(7,null,20),
  new MapDef(8,null,21),
  new MapDef(9,null,22),
  new MapDef(10,null,23),
  new MapDef(11,null,24),
  new MapDef(12,null,25),
  new MapDef(112,null,59),
  new MapDef(13,null,1),	//back
  
  new MapDef(14,null,4),	//Tab
  new MapDef(15,null,26),
  new MapDef(16,null,27),
  new MapDef(17,null,28),
  new MapDef(18,null,29),
  new MapDef(19,null,30),
  new MapDef(20,null,31),
  new MapDef(21,null,32),
  new MapDef(22,null,33),
  new MapDef(23,null,34),
  new MapDef(24,null,35),
  new MapDef(25,"\""),
  new MapDef(26,""),
  new MapDef(27,null,0),	//return
  
  new MapDef(28,null,62),	//Caps
  new MapDef(29,null,36),
  new MapDef(30,null,37),
  new MapDef(31,null,38),
  new MapDef(32,null,39),
  new MapDef(33,null,40),
  new MapDef(34,null,41),
  new MapDef(35,null,42),
  new MapDef(36,null,43),
  new MapDef(37,null,44),
  new MapDef(38,null,45),
  new MapDef(39,null,46),
  new MapDef(40,null,47),

  new MapDef(41,null,3),	//Shift
  new MapDef(43,null,48),
  new MapDef(44,null,49),
  new MapDef(45,null,50),
  new MapDef(46,null,51),
  new MapDef(47,null,52),
  new MapDef(48,null,53),
  new MapDef(49,null,54),
  new MapDef(50,null,55),
  new MapDef(51,null,56),
  new MapDef(52,null,57),
  new MapDef(114,null,58),
  new MapDef(53,null,3),	//Shift

  new MapDef(54,"Ctrl"),
  new MapDef(55,"Alt"),
  new MapDef(108, null, 60),
  new MapDef(56, " "),
  new MapDef(109, null, 61),
  new MapDef(110, null, 64),
  new MapDef(57,"AltGr"),
  new MapDef(58,"Ctrl"),

  new MapDef(59,"Esc"),
  new MapDef(60,"F1"),
  new MapDef(61,"F2"),
  new MapDef(62,"F3"),
  new MapDef(63,"F4"),
  new MapDef(64,"F5"),
  new MapDef(65,"F6"),
  new MapDef(66,"F7"),
  new MapDef(67,"F8"),
  new MapDef(68,"F9"),
  new MapDef(69,"F10"),
  new MapDef(70,"F11"),
  new MapDef(71,"F12"),
  
  new MapDef(72,"Print"),
  new MapDef(73,null,13),	//Scroll
  new MapDef(74,"Pause"),
  
  new MapDef(75,"Ins"),
  new MapDef(76,null,11),	//Home
  new MapDef(77,null,9),	//PgUp
  new MapDef(78,"Del"),
  new MapDef(79,"End"),
  new MapDef(80,null,10),  	//PgDn
  
  new MapDef(81,null,5),	//Up
  new MapDef(82,null,7),	//Left
  new MapDef(83,null,6),	//Down
  new MapDef(84,null,8),	//Right
  
  new MapDef(85,null,12),	//Num
  new MapDef(86,null,11),	//home
  new MapDef(87,null,5),	//Up
  new MapDef(88,null,9),	//PgUp
  new MapDef(89,"+"),
  
  new MapDef(90,"/"),  
  new MapDef(91,null,7),	//Left
  new MapDef(92,"5"),
  new MapDef(93,null,8),	//Right
  
  new MapDef(94,"*"),
  new MapDef(95,"End"),	
  new MapDef(96,null,6),	//Down
  new MapDef(97,null,10),	//PgDn
  new MapDef(98,null,0),	//NumRet
  
  new MapDef(99,"-"),
  new MapDef(100,"Ins"),
  new MapDef(101,"Del"),
  
  new MapDef(102,"Ctrl"),
  new MapDef(103,"Alt"),
  new MapDef(104,"Reset"),
  new MapDef(105,"St"),
  new MapDef(106,"Me"),
  new MapDef(107,"St"),
  new MapDef(KeyDef.PAGE,"Page"),
  new MapDef(KeyDef.POPUP,"Menu"),
 };
 
 static private MapDef[] map_num = {
  new MapDef(86,"7"),
  new MapDef(87,"8"),
  new MapDef(88,"9"),
  
  new MapDef(91,"4"),
  new MapDef(93,"6"),
  
  new MapDef(95,"1"),
  new MapDef(96,"2"),
  new MapDef(97,"3"),
  
  new MapDef(100,"0"),
  new MapDef(101,","),
 };

 protected MapDef[] getMapDefs(java.lang.Short mod)
 {
  switch (mod.shortValue())
  {
   case KeyDef.NOP: return map_norm;
   case 85: return map_num;
   default: return null;
  } 
 }
 
 protected String getKeyImgName(java.lang.Short mod)
 {
  switch (mod.shortValue())
  {
   case KeyDef.NOP: return "nn/pp/rcsoftkbd/japannorm.gif";   
   default: return null;
  } 	
 }	
 
 protected void getMappingPrefs(MappingPrefs prefs)
 {
 	prefs.ImageWidth = 12;
 	prefs.ImageExtWidth = 36;
 	prefs.ImageThreshold = 60;
 } 
 
 public short getKeyImgHeight()
 {
  return 12;
 } 
 
 public Locale getLocale()
 {
	return new Locale("ja", "JP");
 }
}
