package nn.pp.rcsoftkbd;

import nn.pp.rckbd.*;
import java.lang.*;
import java.awt.*;
import java.util.*;

class Key {
    private SoftKbdImpl parent;
    KeyDef keydef;
    MapDef mapdef;
    private boolean over=false;
    private boolean clicked=false;
    public Short shortnumber;
    public Dimension size;
    public Point pos;
    public Color backgroundcolor=NORMALCOLOR;
    static final Color NORMALCOLOR=new Color(220,220,220);
    static final Color OVERCOLOR=new Color(170,170,170);
    static final Color PRESSEDCOLOR=new Color(150, 150, 255);
	
    public Key(SoftKbdImpl parent, KeyDef keydef, MapDef mapdef,
	       Dimension size, Point position){
 	this.parent=parent;
  	this.keydef=keydef;
  	this.mapdef=mapdef;
  	this.size=size;
  	this.pos=position;
  	this.shortnumber=new java.lang.Short(keydef.keynr);
    }

    // Umschalten zwischen Mappings (AltGr, Shift)
    public void changeMapDef(MapDef mapdef) {		
 	this.mapdef = mapdef;
	repaint();
    }

    public void setOver(boolean over){
 	this.over = over;
  	if (over) 
	    if(clicked) backgroundcolor = PRESSEDCOLOR;
	    else backgroundcolor=OVERCOLOR;
  	else 
	    if(clicked) backgroundcolor = PRESSEDCOLOR;
	    else backgroundcolor = NORMALCOLOR;
  	repaint();
    } 
 
    public void setClicked(boolean clicked){
 	this.clicked = clicked;
  	if (clicked) 
	    backgroundcolor = PRESSEDCOLOR;
  	else 
	    if (over) backgroundcolor = OVERCOLOR; 
	    else backgroundcolor = NORMALCOLOR;
  	repaint();
    } 
 
    public boolean isOver(){
 	return over;
    }
 
    public boolean isClicked(){
 	return clicked;
    }
 
    public boolean contains(Point p){
  	if(!(p.x < pos.x) && !(p.x > (pos.x+size.width))) 
	    if (!(p.y < pos.y) && !(p.y > (pos.y+size.height))) 
    		return true;
	return false;
    }  

    private void repaint() {
  	parent.repaint(this);
    }
} 
 
 
  
