package nn.pp.sara;

import java.awt.*;
import java.awt.event.*;
import java.net.*;
import nn.pp.rc.*;

public class ButtonsPanel extends Panel implements ActionListener {
    private static final int PRESS_PLAY_BUTTON = 0;
    private static final int PRESS_PAUSE_BUTTON = 1;
    private static final int PRESS_STOP_BUTTON = 2;
    
    private URL codeBase;
    private ReplayPanel replay;
    private Dimension btnDim;
    private ImageButton playButton, pauseButton, stopButton;
    private Image playImage, pauseImage, stopImage;
    private FixedLabel stateLabel;
    
    public ButtonsPanel(URL codeBase, ReplayPanel replay) {
    	this.codeBase = codeBase;
    	this.replay = replay;
    	addLayout();
    }
    
    private void addLayout() {
    	setLayout(new BorderLayout());
    	
    	Panel p = new Panel();
    	
    	p.setLayout(new FlowLayout(FlowLayout.LEFT));

	btnDim = new Dimension(33, 32);
	ImageLoader imgloader = new ImageLoader(codeBase);
	playImage = imgloader.loadImage("nn/pp/sara/icon_play.gif");
	pauseImage = imgloader.loadImage("nn/pp/sara/icon_pau.gif");
	stopImage = imgloader.loadImage("nn/pp/sara/icon_sto.gif");
	
	playButton = new ImageButton("  " + T._("Play"), playImage, btnDim, 0);
	pauseButton = new ImageButton("  " + T._("Pause"), pauseImage, btnDim, 0);
	stopButton = new ImageButton("  " + T._("Stop"), stopImage, btnDim, 0);
	
	playButton.addActionListener(this);
	pauseButton.addActionListener(this);
	stopButton.addActionListener(this);
	
	p.add(playButton);
	p.add(pauseButton);
	p.add(stopButton);
	
	add(p, BorderLayout.CENTER);
	
	stateLabel = new FixedLabel("");
	
	add(stateLabel, BorderLayout.EAST);
    }

    public void setEnabled(boolean b) {
    	playButton.setEnabled(b);
    	pauseButton.setEnabled(b);
    	stopButton.setEnabled(b);
    	stateLabel.setEnabled(b);
    	super.setEnabled(b);
    }
    
    public void actionPerformed(ActionEvent e) {
    	Object src = e.getSource();
    	
    	if (src == playButton) {
    	    replay.play();
    	} else if (src == pauseButton) {
    	    replay.pause();
    	} else if (src == stopButton) {
    	    replay.stop();
    	}
    }
    
    private void setPressedButton(int no) {
    	switch (no) {
    	    case PRESS_PLAY_BUTTON:
    	    	playButton.setImageIndex(1);
    	    	pauseButton.setImageIndex(0);
    	    	stopButton.setImageIndex(0);
    	    	break;
    	    case PRESS_PAUSE_BUTTON:
    	    	playButton.setImageIndex(0);
    	    	pauseButton.setImageIndex(1);
    	    	stopButton.setImageIndex(0);
    	    	break;
    	    case PRESS_STOP_BUTTON:
    	    	playButton.setImageIndex(0);
    	    	pauseButton.setImageIndex(0);
    	    	stopButton.setImageIndex(1);
    	    	break;
    	}
    }
    
    void play() {
    	setPressedButton(PRESS_PLAY_BUTTON);
    	stateLabel.setText(T._("Playing"));
    }
    
    void pause() {
    	setPressedButton(PRESS_PAUSE_BUTTON);
    	stateLabel.setText(T._("Paused"));
    }
    
    void stop() {
    	setPressedButton(PRESS_STOP_BUTTON);
    	stateLabel.setText(T._("Stopped"));
    }
}
