package nn.pp.sara;

import java.awt.*;
import java.awt.event.*;
import nn.pp.rc.*;

class EventLogPanel extends InfoPanelPart implements ActionListener {
    TextArea textarea;
    Button clearButton;

    EventLogPanel(InfoPanel info) {
    	super(info, false, false);
    }
    
    void newEvent(String s) {
    	if (textarea.getText().length() != 0) {
    	    textarea.append("\n");
    	}
    	textarea.append(s);
    }
    
    public void actionPerformed(ActionEvent e) {
	super.actionPerformed(e);
	Object src = e.getSource();
	
	if (src == clearButton) {
	    textarea.setText("");
	}
    }

    public void setEnabled(boolean b) {
    	textarea.setEnabled(b);
    	super.setEnabled(b);
    }
    
    String getHeader() {
    	return "Event Log";
    }
    
    public Dimension getPreferredSize() {
    	return new Dimension(700, super.getPreferredSize().height);
    }
    
    void addPartLayout() {
    	Panel textClearPanel = new Panel(new BorderLayout());
    	
    	Panel textPanel = new Panel(new GridLayout(1, 1));
    	textarea = new TextArea("", 4, 4, TextArea.SCROLLBARS_BOTH);
    	textarea.setEditable(false);
    	textPanel.add(textarea);
    	
    	Panel clearButtonPanel = new Panel(new FlowLayout());
    	clearButton = new Button("Clear");
    	clearButton.addActionListener(this);
    	clearButtonPanel.add(clearButton);
    	
    	textClearPanel.add(clearButtonPanel, BorderLayout.EAST);
    	textClearPanel.add(textPanel, BorderLayout.CENTER);
    	
    	add(textClearPanel, BorderLayout.CENTER);
    }
    
    void handlePartSasEvent(SasEvent evt) {
    	// nothing to do here
    }
    
}
