package nn.pp.sara;

import java.awt.*;
import java.util.*;
import nn.pp.rc.*;
import nn.pp.rckbd.*;
import nn.pp.rcsoftkbd.*;

class KeyboardPanel extends InfoPanelPart {
    Label filteredLabel;
    boolean hasSource;
    SoftKbd kbd;
    KbdFactory kbdFactory;
    KeyEventHandler keh;
    
    KeyboardPanel(InfoPanel info, Locale mapping, String defkbd) {
    	super(info, true, true);
    	
    	kbdFactory = KbdFactory.getInstance();
	if (( defkbd == null ) || ( defkbd.length() < 2 ))
	    defkbd = "pc104";	    
	keh = new KeyEventHandler(kbdFactory.getKbdLayout(defkbd));
    	kbd = kbdFactory.getSoftKbd(keh, mapping, "", false);
    }
    
    String getHeader() {
    	return "Keyboard Events";
    }
    
    void addPartLayout() {
    	Panel p = new Panel(new BorderLayout());
    	Panel p2 = new Panel(new BorderLayout());

    	p2.add((filteredLabel = new Label()), BorderLayout.CENTER);

    	p.add(kbd.getAsPanel(), BorderLayout.CENTER);
    	p.add(p2, BorderLayout.SOUTH);

    	add(p, BorderLayout.CENTER);
    }
    
    private String getKeyName(Short keyno) {
    	if (keyno.shortValue() == 0x7f) {
    	    return "(filtered)";
    	}
    	String s = keh.getKeyString(keyno);
    	if (s != null) {
    	    return "'" + s + "'";
    	}
    	
    	return "0x" + Integer.toHexString(keyno.intValue());
    }
    
    void handlePartSasEvent(SasEvent evt) {
    	int keyno = evt.inputEvent.keycode;
    	boolean down = (keyno & 0x80) == 0x80;
    	keyno &= 0x7f;
    	Short sKeyno = new Short((short)keyno);
    	
    	if (keyno == 0x7f) {
    	    if (down) {
    	    	filteredLabel.setText("Filtered keys");
    	    } else {
    	    	filteredLabel.setText("");
    	    }
    	} else if (down) {
    	    keh.internalPressed(sKeyno, KeyEventHandler.KEYBOARD);
    	} else {
    	    keh.released(sKeyno, KeyEventHandler.KEYBOARD);
    	}
    	
    	String s = "Key " + getKeyName(sKeyno) + " ";
    	if (down) {
    	    s += "pressed";
    	} else {
    	    s += "released";
    	}
    	info.newEvent(this, evt, "Keyboard", s);
    }

    public void newKbdMapping(Locale locale) {
    	kbd.setMapping(locale);
    }
    
    public void newKbdLayout(String layout) {
    	kbd.setLayout(layout);
    	info.pack();
    }
}
