package nn.pp.sara;

import java.awt.*;

class MouseVisual extends Canvas {
    MousePanel panel;
    int buttonMask = 0;
    int wheel = 0;
    
    int bw = 15;	// button width
    int bh = 25;	// button height
    int mh = 80;	// mouse height
    int r = 20;		// radius of arc
    int wl = 10;	// wire length
    int ml = 10;	// mouse left pos
    int mt = 5;		// mouse top pos
    int wh = 5;		// wheel height
    int ww = 6;		// wheel width
    
    Color cm = Color.BLACK;	// mouse color
    Color cbd = Color.RED;	// button down
    Color cwa = Color.GREEN;	// wheel active
    Color cwi = Color.BLACK;	// wheel inactive
    
    Graphics bufferGraphics;
    Image offscreen; 

    MouseVisual(MousePanel panel) {
    	this.panel = panel;
    }
    
    public Dimension getMinimumSize() {
    	return new Dimension(3 * bw + 2 * wl, mh + 2 * mt + wl);
    }
    
    public Dimension getPreferredSize() {
    	return getMinimumSize();
    }
    
    private void initDoubleBuffer() {
    	Dimension dim = getMinimumSize();
    	offscreen = createImage(dim.width,dim.height);
    	bufferGraphics = offscreen.getGraphics();
    }
    
    public void update(Graphics g) {
    	paint(g);
    }
    
    public void paint(Graphics g) {
    	if (bufferGraphics == null) {
    	    initDoubleBuffer();
    	}
    	paintMouse(bufferGraphics);
    	g.drawImage(offscreen,0,0,this);
    }
    
    private void paintMouse(Graphics g) {    	
    	int i;
    	
    	int b1x = ml, b2x = b1x + bw, b3x = b2x + bw, b3x2 = b3x + bw;
    	int by1 = mt + wl, by2 = by1 + bh;
    	int by3 = mh + by1 - r/2;
    	
    	g.setColor(cm);
    	
    	// lines at top and bottom of buttons
    	g.drawLine(b1x, by1, b3x2, by1);
    	g.drawLine(b1x, by2, b3x2, by2);
    	
    	// button lines (up/down)
    	g.drawLine(b1x, by1, b1x, by2);
    	g.drawLine(b2x, by1, b2x, by2);
    	g.drawLine(b3x, by1, b3x, by2);
    	g.drawLine(b3x2, by1, b3x2, by2);
    	
    	// lines down
    	g.drawLine(b1x, by2, b1x, by3);
    	g.drawLine(b3x2, by2, b3x2, by3);
    	
    	// arc bottom
    	g.drawArc(b1x, by3 - r/2, b3x2 - b1x, r, 180, 180);
    	
    	// wire
    	g.drawLine((b1x + b3x2) / 2, mt, (b1x + b3x2) / 2, by1);
    	
    	// pressed buttons
    	int xf[] = { b1x + 1, b2x + 1, b3x + 1 };
    	int yf = by1 + 1;
    	int wf = bw - 1;
    	int hf = bh - 1;
    	for (i = 0; i < 3; i++) {
    	    if ((buttonMask & (1 << i)) != 0) {
    	    	g.setColor(cbd);
    	    } else {
    	    	g.setColor(getBackground());
    	    }
    	    
    	    g.fillRect(xf[i], yf, wf, hf);
    	}
    	
    	// wheel
    	Color cw[] = new Color[2];
    	if (wheel < 0) {
    	    cw[0] = cwa;
    	    cw[1] = cwi;
    	} else if (wheel > 0) {
    	    cw[0] = cwi;
    	    cw[1] = cwa;
    	} else {
    	    cw[0] = cwi;
    	    cw[1] = cwi;
    	}
    	int _x = (b1x + b3x2) / 2;
    	int _y1 = by1 + 2;
    	int _y2 = by2 - 2;
    	int wx[][] = { { _x, _x - (ww / 2), _x + (ww / 2)  }, { _x - (ww / 2), _x, _x + (ww / 2) } };
    	int wy[][] = { { _y1, _y1 + wh, _y1 + wh }, { _y2 - wh, _y2, _y2 - wh } };
    	
    	for (i = 0; i < 2; i++) {
    	    g.setColor(cw[i]);
    	    g.drawPolygon(wx[i], wy[i], 3);
    	    g.fillPolygon(wx[i], wy[i], 3);
    	}
    }

    void processButtons(int mask) {
    	buttonMask = mask;
    	repaint();
    }
    
    void processWheel(int wheel) {
    	this.wheel = wheel;
    	repaint();
    }
}
