package nn.pp.sara;

import java.awt.*;
import java.util.*;
import java.net.*;
import nn.pp.rc.*;

public class SasForensicPanel extends ForensicPanel {
    InfoPanel infoPanel;
    ReplayPanel replayPanel;
    Locale locale;
    String defkbd;
    
    public SasForensicPanel(URL codeBase, String defkbd, Locale locale) {
    	super(codeBase);
    	this.locale = locale;
    	this.defkbd = defkbd;
    }
    
    public void init(boolean showEvents, boolean localOnly, boolean noKbd, boolean showReplay, String kbdLayout) {
    	if (kbdLayout == null) {
    	    kbdLayout = defkbd;
    	}
    	if (showEvents) {
    	    System.out.println("Adding info panel");
    	    infoPanel = new InfoPanel(codeBase, locale, kbdLayout, this, localOnly, noKbd);
    	} else {
    	    System.out.println("No info panel");
    	}
    	if (showReplay) {
    	    System.out.println("Adding replay panel");
    	    replayPanel = new ReplayPanel(codeBase, this);
    	} else {
    	    System.out.println("No replay panel");
    	}
    	
    	addLayout();
    }
    
    private void addLayout() {
    	setLayout(new BorderLayout());
    	
    	if (infoPanel != null) {
    	    add(infoPanel, BorderLayout.NORTH);
    	}
    	if (replayPanel != null) {
    	    add(replayPanel, BorderLayout.SOUTH);
    	}
    }
    
    public void setEnabled(boolean b) {
    	if (infoPanel != null) {
    	    infoPanel.setEnabled(b);
    	}
    	if (replayPanel != null) {
    	    replayPanel.setEnabled(b);
    	}
    }
    
    public void handleSasEvent(SasEvent evt) {
    	if (infoPanel != null) {
    	    infoPanel.handleSasEvent(evt);
    	}
    }

    public void handleSpEvent(SpEvent evt) {
    	if (replayPanel != null) {
    	    replayPanel.handleSpEvent(evt);
    	}
    }

    public void setFramebufferFormat(int width, int height, int bitsPerPixel) {
    	if (replayPanel != null) {
    	    replayPanel.setFramebufferFormat(width, height, bitsPerPixel);
    	}
    }
    
    public void setSessionInfo(RecordedSessionInfo info) {
    	if (replayPanel != null) {
    	    replayPanel.setSessionInfo(info);
    	}
    	if (infoPanel != null) {
    	    infoPanel.setHost(info.hostName, info.hostAddress);
    	}
    }

    public void newKbdMapping(Locale locale) {
    	if (infoPanel != null) {
    	    infoPanel.newKbdMapping(locale);
    	}
    }
    
    public void newKbdLayout(String layout) {
    	if (infoPanel != null) {
    	    infoPanel.newKbdLayout(layout);
    	}
    }

    public void show() {
    	super.show();
    	
    	if (infoPanel != null) {
    	    infoPanel.show();
    	}
    	if (replayPanel != null) {
    	    replayPanel.show();
    	}
    }

    public void hide() {
    	super.hide();
    	
    	if (infoPanel != null) {
    	    infoPanel.hide();
    	}
    	if (replayPanel != null) {
    	    replayPanel.hide();
    	}
    }
}
