package nn.pp.sara;

import java.awt.*;
import java.util.*;
import java.text.*;
import nn.pp.rc.*;

class FixedList extends java.awt.List {
    String s;
    private Dimension mydim = null;
    
    FixedList(String s, int rows, boolean multipleMode) {
    	super(rows);
    	this.s = s;
    }

    FixedList(String s, int rows) {
    	this(s, rows, false);
    }

    FixedList(String s) {
    	this(s, 0, false);
    }

    public Dimension getMinimumSize() {
	if (mydim == null) {
	    Font fontLabel = getFont();
	    FontMetrics fontMetrics = getFontMetrics(fontLabel);
	    mydim = new Dimension(fontMetrics.stringWidth(s),
				  super.getMinimumSize().height);
	}
	return mydim;
    }
	
    public Dimension getPreferredSize() {
	return getMinimumSize();
    }
}

class SessionsPanel extends InfoPanelPart {
    Label sourceLabel;
    boolean hasSource;
    FixedList sessionList;
    
    SessionsPanel(InfoPanel info) {
    	super(info, false, true);
    }
    
    String getHeader() {
    	return "Open Sessions";
    }
    
    void addPartLayout() {
    	sessionList = new FixedList("xxxxxxxxxxxxxxxx (888.888.888.888) - 88:88:88 - KVM excl");
    	add(sessionList, BorderLayout.CENTER);
    }
    
    synchronized private void updateList() {
    	sessionList.removeAll();
    	Vector vec = info.getSessions();
    	for (Enumeration e = vec.elements(); e.hasMoreElements(); ) {
    	    String entry = (String)e.nextElement();
    	    sessionList.add(entry);
    	}
    }
    
    // event handling
    synchronized private void handleExistingSession(Long session, SasEvent evt) {
    	UserSession e = new UserSession(evt.exSession.user, evt.exSession.ip, evt.exSession.loginTime, evt.exSession.self);
    	info.putSession(session, e);
    }
    
    synchronized private void handleExistingKvmSession(Long session, SasEvent evt) {
    	UserSession e = info.getSession(session);
    	e.setKvm(evt.exKvmSession.kvmSessionId, true);
    	e.setExclusive(evt.exKvmSession.kvmSessionId, evt.exKvmSession.exclusive);
    }
    
    synchronized private void handleUserSessionOpened(Long session, SasEvent evt) {
    	UserSession e = new UserSession(evt.newSession.user, evt.newSession.ip, evt.newSession.loginTime, false);
    	info.putSession(session, e);
    	
    	info.newEvent(this, evt, "New session");
    }
    
    synchronized private void handleUserSessionClosed(Long session, SasEvent evt) {
    	info.newEvent(this, evt, "Session closed");
    	info.removeSession(session);
    }
    
    synchronized private void handleKvmSessionOpened(Long session, SasEvent evt) {
    	UserSession e = info.getSession(session);
    	e.setKvm(evt.causingKvmSession, true);
    	
    	info.newEvent(this, evt, "New KVM session");
    }
    
    synchronized private void handleKvmSessionClosed(Long session, SasEvent evt) {
    	UserSession e = info.getSession(session);
    	e.setKvm(evt.causingKvmSession, false);
    	
    	info.newEvent(this, evt, "KVM Session closed");
    }
    
    synchronized private void handleKvmExclusiveOn(Long session, SasEvent evt) {
    	UserSession e = info.getSession(session);
    	e.setExclusive(evt.causingKvmSession, true);
    	
    	info.newEvent(this, evt, "KVM Exclusive mode entered");
    }
    
    synchronized private void handleKvmExclusiveOff(Long session, SasEvent evt) {
    	UserSession e = info.getSession(session);
    	e.setExclusive(evt.causingKvmSession, false);
    	
    	info.newEvent(this, evt, "KVM Exclusive mode left");
    }
    
    synchronized private void resetSessions() {
    	info.removeAllSessions();
    }
    
    void handlePartSasEvent(SasEvent evt) {
    	Long session = new Long(evt.session);
    	
    	switch (evt.type) {
    	    case SasEvent.ExistingSession:
    	    	if (evt.exSession != null) {
    	    	    handleExistingSession(session, evt);
    	    	}
    	    	break;
    	    case SasEvent.ExistingKvmSession:
    	    	if (evt.exKvmSession != null) {
    	    	    handleExistingKvmSession(session, evt);
    	    	}
    	    	break;
    	    case SasEvent.UserSessionOpened:
    	    	handleUserSessionOpened(session, evt);
    	    	break;
    	    case SasEvent.UserSessionClosed:
    	    	handleUserSessionClosed(session, evt);
    	    	break;
    	    case SasEvent.KvmSessionOpened:
    	    	handleKvmSessionOpened(session, evt);
    	    	break;
    	    case SasEvent.KvmSessionClosed:
    	    	handleKvmSessionClosed(session, evt);
    	    	break;
    	    case SasEvent.KvmExclusiveOn:
    	    	handleKvmExclusiveOn(session, evt);
    	    	break;
    	    case SasEvent.KvmExclusiveOff:
    	    	handleKvmExclusiveOff(session, evt);
    	    	break;
    	    case SasEvent.ResetSessions:
    	    	resetSessions();
    	    	break;
    	    
    	    default:
    	    	return;
    	}
    	
    	updateList();
    }
}
