package nn.pp.sara;

import java.util.*;
import java.text.*;
import nn.pp.rc.*;

class UserSession {
    String user;
    String ip;
    Date time;
    boolean self;
    private Hashtable kvmTable;

    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    
    UserSession(String user, String ip, Date time, boolean self) {
    	this.user = user;
    	this.ip = ip;
    	this.self = self;
    	this.time = time;
    	
    	kvmTable = new Hashtable();
    }
    
    synchronized public String toString() {
    	String s = "";
    	if (self) {
    	    s += "* ";
    	}
    	s += user + " (" + ip + ") - " + dateFormat.format(time).toString();

    	int size = kvmTable.size();
    	if (size > 0) {
    	    s += " - KVM";
    	    if (size > 1) {
    	    	s += " (" + size + ")";
    	    }
    	    for (Enumeration e = kvmTable.elements(); e.hasMoreElements(); ) {
    	    	UserKvmSession entry = (UserKvmSession)e.nextElement();
    	    	if (entry.exclusive) {
    	    	    s += " excl";
    	    	    break;
    	    	}
    	    }
    	}
    	
    	return s;
    }
    
    synchronized void putKvm(Long key, UserKvmSession newEntry) {
    	UserKvmSession e;
    	
    	if ((e = (UserKvmSession)kvmTable.get(key)) != null) {
    	    System.out.println("Already found KVM session 0x" + Long.toHexString(key.longValue()));
    	    kvmTable.remove(key);
    	}

    	kvmTable.put(key, newEntry);
    }
    
    synchronized UserKvmSession getKvm(Long key) {
    	UserKvmSession e = (UserKvmSession)kvmTable.get(key);
    	if (e == null) {
    	    e = new UserKvmSession(false);
    	    putKvm(key, e);
    	}
    	
    	return e;
    }
    
    synchronized void removeKvm(Long key) {
    	kvmTable.remove(key);
    }
    
    // FIXME!!
    synchronized void setKvm(long kvmId, boolean kvm) {
    	Long id = new Long(kvmId);
    	if (kvm) {
    	    putKvm(id, new UserKvmSession(false));
    	} else {
    	    removeKvm(id);
    	}
    }
    
    synchronized void setExclusive(long kvmId, boolean excl) {
    	UserKvmSession kvm = getKvm(new Long(kvmId));
    	kvm.exclusive = excl;
    }
}

