/*
 * flashid_calc
 *
 * calculates a HMAC hash value from a number of input
 * bytes using a common key and outputs the new hash
 *
 * input parameters:  array of bytes (hex)
 * output:	      array of bytes (hex), hmac hash
 *
 * ATTENTION: its bloaty to statically link openssl but this binary
 *	      is only needed for the production filesystem so it doesnt
 *	      matter
 */

#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/resource.h>
#include <sys/time.h>
#include <pp/hal_common.h>
#include <openssl/hmac.h>

unsigned char flashid_sig_key[] = PP_HAL_COMMON_FLASHID_SIG_KEY_INITIALIZER;

int
main(int argc, char ** argv)
{
    int ret = 1, i, inlen, outlen;
    unsigned char* inbuf = NULL, outbuf[HMAC_MAX_MD_CBLOCK];
    
    if (argc < 2) {
	printf("Error: No input value specified\n"
	       "       Parameter: array of bytes(hex), xxyyzz...\n");
	goto bail;
    }

    inlen = strlen(argv[1]);

    if (inlen % 2) {
	printf("Error: Odd number of input characters not allowed\n");
	goto bail;
    }

    inbuf = malloc(inlen/2);
    
    if (inbuf == NULL) {
	printf("Error: Could not allocate buffery memory\n");
	goto bail;
    }
    
    for (i = 0; i < inlen; i += 2) {
	unsigned char buf[3];
	
	memcpy(buf, &argv[1][i], 2);
	buf[2]= '\0';
	
	inbuf[i/2] = strtol(buf, NULL, 16);
    }
    
    HMAC(EVP_md5(), flashid_sig_key, sizeof(flashid_sig_key),
	inbuf, inlen/2, outbuf, &outlen);
    
    for (i = 0; i < outlen && i < 16; i++) {
	printf("%02X", outbuf[i]);
    }
    printf("\n");
    
    ret = 0;

 bail:
    if (inbuf) free(inbuf);
    return ret;
}
