#!/bin/sh

FLASHID_FACT="/proc/mtd_prot_fact"
FLASHID_USER="/proc/mtd_prot_user"
FLASHID_LOCK="/proc/mtd_prot_lock"
FLASHID_CALC="/bin/flashid_calc"

# check if already set
flashid_lock=`cat $FLASHID_LOCK`
if [ "$flashid_lock" = "1" ]; then
    echo "Flash ID already locked, nothing to do."
    exit 0
fi

if [ -e $FLASHID_CALC ]; then
# encrypt/hash the flashid and write it to flash protection register
    flashid_fact=`cat $FLASHID_FACT`
    flashid_user=`$FLASHID_CALC $flashid_fact`
    if [ $? -ne 0 ]; then
        echo "Flash ID calculation failed. This is a BUG, should never happen."
        sleep 1
        exit 1
    fi
    echo $flashid_user > $FLASHID_USER
    echo 1 > $FLASHID_LOCK

    echo "Set and locked Flash ID."
    exit 2
fi

echo "Warning: Flash ID not found and calculation is not available."
exit 0
