#!/bin/sh

# lock dir
LOCKDIR=/var/lock/flash_config.lock

cleanup() {
    rm -rf $LOCKDIR
}

flash_config_prepare () {
    device=$1
    mountpoint=$2
    umount $device > /dev/null 2>&1
    fsck.minix -f $device && \
	mount -t minix $device $mountpoint
    if [ $? != 0 ]; then
	mkfs.minix $device > /dev/null
	mount -t minix $device $mountpoint
	if [ $? != 0 ]; then
	    echo "Cannot write config to to $device."
	    return
	fi
    fi
    echo "Writing config to $device ..."
    rm -rf $mountpoint/*
    mkdir -p $mountpoint/config
}

flash_config_copy_cfg () {
    device=$1
    mountpoint=$2
    # We first write !config to ensure we have enough space for it!
    if [ -r /config/!config ]; then
	cp -f /config/!config $mountpoint/config/
    fi
    if [ -r /config/!system ]; then
	cp -f /config/!system $mountpoint/config/
    fi
}

sync_file () {
    file=$1
    mountpoint=$2

    if [ -e $file ]; then
        # copy the file
        cp -fr $file $mountpoint 2> /dev/null || :
    else
        # file is deleted in source dir, delete in config as well
	filename=`basename $file`
	rm -fr $mountpoint/$filename 2> /dev/null || :
    fi
}

flash_config_copy_misc () {
    device=$1
    mountpoint=$2
    PWD=`pwd`
    cd /config
    if [ $? != 0 ]; then
	echo "No config data to write to $device."
	umount $mountpoint
	return
    fi
    for i in *; do
	if [ "$i" != "!config" ]; then
	    # do not flash temporary files or defaults!
	    if [ -n "`echo $i | sed 's,.*_tmp,,'`" -a -n "`echo $i | sed 's,.*_default,,'`" ]; then
		cp -f $i $mountpoint/config/
	    fi
	fi
    done
    
    cd $PWD
    #
    # NOTE: If you add stuff here you need to update default_config_be.sh!
    #
    sync_file /etc/e-RIC/ssl/ca $mountpoint/
    sync_file /etc/e-RIC/ssl/erickey_user.pem $mountpoint/
    sync_file /etc/e-RIC/ssl/ericcert_user.pem $mountpoint/
    sync_file /etc/e-RIC/ssl/erickey_new.pem $mountpoint/
    sync_file /etc/e-RIC/ssl/ericcert_new.pem $mountpoint/
    sync_file /etc/e-RIC/ssl/csr.txt $mountpoint/
    sync_file /lib/webpages/custom.html $mountpoint/
    for f in "/etc/vsc/modedata/vsc*"; do
        sync_file $f $mountpoint/
    done
    if [ -s /var/log/evtlog ]; then
        gzip -9c /var/log/evtlog > $mountpoint/evtlog.gz 2> /dev/null || rm -f $mountpoint/evtlog.gz
    else
        rm -f $mountpoint/evtlog.gz
    fi

    umount $mountpoint
}

# this is executed if called  with parameter in_flush_lock
if [ "$1" = "in_flush_lock" ]; then
    flash_config_copy_cfg /dev/mtdblock2 /config_flash
    flash_config_copy_cfg /dev/mtdblock4 /config_flash2
    exit 0
fi

mkdir $LOCKDIR 2> /dev/null
while [ $? != 0 ]; do
    echo "Waiting for lock $LOCKDIR"
    sleep 1
    mkdir $LOCKDIR 2> /dev/null
done

# FIXME: race condition!
trap cleanup EXIT HUP INT TERM

# mount block devices and prepare FS
flash_config_prepare /dev/mtdblock2 /config_flash
flash_config_prepare /dev/mtdblock4 /config_flash2

# lock cfg file access and copy it to flash partitions
# NOTE: we call us recursively!
/bin/eric_config -call_with_flush_lock $0 in_flush_lock

# copy the rest and umount
flash_config_copy_misc /dev/mtdblock2 /config_flash
flash_config_copy_misc /dev/mtdblock4 /config_flash2

# lock is removed in cleanup handler!
