# Topology for RPC: global declarations, valid for all models
# 2006/10/18 tbr@raritan.com

# buses
i2c_bus_0:       I2C("faraday-1");
kira_gpiodev:    FpgaGpio("gpio-faraday");
rs485_act_dir:   GpioAct(kira_gpiodev, 5, 1, 0, false);
rs485_bus:       RS485("/dev/ttyS1", rs485_act_dir);


# sdr config for threshold sensors
# TODO: thresholds/event masks are not adjusted yet!!!
# arguments:            cap,  assm,   deam,   setm, redm, nom,  max,  min,
#                       nrup, crup,   ncup,   nrlo, crlo, nclo, posh, negh
sdr_u_temp:   ThreshSDR(0x68, 0x7a95, 0x7a95, 0x3f, 0x3f, 0x2d, 0xf0, 0x00,
                        0x5a, 0x57,   0x55,   0x00, 0x02, 0x04, 0x05, 0x05);
sdr_u_curr:   ThreshSDR(0x68, 0x0a80, 0x7a80, 0x38, 0x38, 0x01, 0x0a, 0x00,
                        0xff, 0xff,   0xff,   0x00, 0x00, 0x00, 0x01, 0x01);
sdr_b_volt:   ThreshSDR(0x68, 0x7a95, 0x7a95, 0x3f, 0x3f, 0x6e, 0xe6, 0x00,
                        0xff, 0xfa,   0xfa,   0x4c, 0x4f, 0x51, 0x05, 0x05);
sdr_b_freq:   ThreshSDR(0x68, 0x7a95, 0x7a95, 0x3f, 0x3f, 0x3c, 0x46, 0x32,
                        0x4b, 0x46,   0x41,   0x00, 0x00, 0x00, 0x05, 0x05);
sdr_r_curr:   ThreshSDR(0x68, 0x0a80, 0x7a80, 0x38, 0x38, 0x00, 0x0a, 0x00,
                        0x64, 0x64,   0x64,   0x00, 0x00, 0x00, 0x00, 0x00);
sdr_r_phase:  ThreshSDR(0x68, 0x0a80, 0x7a80, 0x38, 0x38, 0x00, 0xb4, 0x00,
                        0xff, 0xff,   0xff,   0x00, 0x00, 0x00, 0x0a, 0x00);
sdr_r_pwr:    ThreshSDR(0x68, 0x0a80, 0x7a80, 0x38, 0x38, 0x4b, 0xfa, 0x00,
                        0xff, 0xfa,   0xf0,   0x00, 0x00, 0x00, 0x0a, 0x0a);

# SDR configs for discrete sensors
# arguments:            cap,  assm,   deam,   rdm
sdr_u_cbrk:     DiscSDR(0x40, 0x0001, 0x0001, 0x0003);


# receptacle and board related templates
B_SENS_VOLT:     RCCY8C26Sens(?, 0);
B_SENS_FREQ:     RCCY8C26Sens(?, 1);

R_ACT_STATE:     GpioAct(?, 0, 1, 0);
R_ACT_LED_RED:   GpioAct(?, 4, 1, 0);
R_ACT_LED_GREEN: GpioAct(?, 5, 1, 0);

R_SENS_STATE:    GpioSens(?, 0, false, 0);
R_SENS_CURR:     RCCY8C26Sens(?, 0, ?);
R_SENS_PHASE:    RCCY8C26Sens(?, 1, ?);

R_SENS_AVG_PWR:  RMSPowerSens(?, ?, 60);

U_ISENS_CBRK:    ISens(?, ?, ?, 19, 0, sdr_u_cbrk);
U_ISENS_TEMP:    ISens(?, ?, ?, 19, 0, sdr_u_temp);
U_ISENS_CURR:    ISens(?, ?, ?, 19, 0, sdr_u_curr);
B_ISENS_VOLT:    ISens(?, ?, ?, 21, 0, sdr_b_volt);
B_ISENS_FREQ:    ISens(?, ?, ?, 21, 0, sdr_b_freq);
R_ISENS_CURR:    ISens(?, ?, ?, 21, 0, sdr_r_curr);
R_ISENS_PHASE:   ISens(?, ?, ?, 21, 0, sdr_r_phase);
R_ISENS_PWR:     ISens(?, ?, ?, 21, 0, sdr_r_pwr);


# independend unit sensors
u_sens_tmp: TMP101Sens(i2c_bus_0, 0x48);
u_tmp: U_ISENS_TEMP(u_sens_tmp, 0xf4, "CPU Temp.");

# 7 segement display actuators, beeper
disp_act_chn:       RPCDispAct(I2CChip(i2c_bus_0, 0x38), 0);
disp_act_val:       RPCDispAct(I2CChip(i2c_bus_0, 0x39), 1);
disp_sens_but_up:   GpioSens(kira_gpiodev, 2, false, 30);
disp_sens_but_down: GpioSens(kira_gpiodev, 1, false, 30);

beep_act:           GpioAct(kira_gpiodev, 6, 0, 1, false);
#pwr_led_act:       GpioAct(kira_gpiodev, 7, 0, 1, false);

