# recepticle number: XX 
# recepticle name:   YY
# sensor numbers:    SS0 SS1 SS2 SS3 SS4 SS5 SS6 SS7 SS8 SS9

rXX_gpiodev:       RCCY8C26Gpio(rXX_chip, rXX_chip_ol);

rXX_act_state:     R_ACT_STATE(rXX_gpiodev);
rXX_act_led_red:   R_ACT_LED_RED(rXX_gpiodev);
rXX_act_led_green: R_ACT_LED_GREEN(rXX_gpiodev);

rXX_sens_state:    R_SENS_STATE(rXX_gpiodev);
rXX_sens_curr:     R_SENS_CURR(rXX_chip, rXX_chip_ol);
rXX_sens_phase:    R_SENS_PHASE(rXX_chip, rXX_chip_ol);

rXX_sens_curr_max: MaxCurrSens(rXX_sens_curr);
rXX_sens_pwr_apt:  AptPowerSens(rXX_sens_volt, rXX_sens_curr);
rXX_sens_pwr_rms:  RMSPowerSens(rXX_sens_pwr_apt, rXX_sens_phase);
rXX_sens_pwr_max:  MaxPowerSens(rXX_sens_pwr_rms);
rXX_sens_pwr_avg:  R_SENS_AVG_PWR(rXX_sens_pwr_apt, rXX_sens_phase);

rXX_curr:          R_ISENS_CURR(rXX_sens_curr, SS0, "R.YY Current");
rXX_pase:          R_ISENS_PHASE(rXX_sens_phase, SS1, "R.YY Phase");
rXX_curr_max:      R_ISENS_CURR(rXX_sens_curr_max, SS2, "R.YY Max Curr");
rXX_pwr_rms:       R_ISENS_PWR(rXX_sens_pwr_rms, SS3, "R.YY RMS Power");
rXX_pwr_apt:       R_ISENS_PWR(rXX_sens_pwr_apt, SS4, "R.YY Apt. Power");
rXX_pwr_max:       R_ISENS_PWR(rXX_sens_pwr_max, SS5, "R.YY Max Power");
rXX_pwr_avg:       R_ISENS_PWR(rXX_sens_pwr_avg, SS6, "R.YY Avg. Power");

rXX_ctrl_led:      RPCOllCtrl(rXX_sens_state, rXX_curr, rXX_sens_cb,
			      rXX_act_led_red, rXX_act_led_green);
