#!/bin/bash
#
# generates receptacle topo files
#
# tbr@raritan.com
#

# calculate ipmi sensor numbers based on receptacle and 
# relative sensor number pf this receptacle 
# number schema is defined in PDU-PSD
# [7-3] - receptacle number, [2-0] - sensor number
function ipmi_sens_number () {
    local rno=$1
    local sno=$2
    local isno=$((($rno * 8) + $sno))
    printf "%#.2x" $isno
}

HELP_MESSAGE="Usage:\n\t`basename $0` <template> <number> <targetpath>\n\
where:\n\
<template> \t generic receptale topo file\n\
<number> \t number of files to generarte, starting with 00\n\
<targetpath> \t dir to create new files in"

if [ $# -ne 3 ] ; then
    echo -e "$HELP_MESSAGE" >&2
    exit 1
fi

templ=$1
cnt=$2
path=$3
recpt="0"

if [ ! -f $templ ] ; then
    echo -e "$templ: no such file!\n"
    echo -e "$HELP_MESSAGE" >&2
    exit 1
fi

if [ ! -d $path ] ; then
    echo -e "$path: no such directory!\n"
    echo -e "$HELP_MESSAGE" >&2
    exit 1
fi

while [ $recpt -lt $cnt ] ; do
    rname=$(($recpt + 1))    
    xx=`printf "%.2d" $recpt`
    yy=`printf "%.2d" $rname`
    ss0=`ipmi_sens_number $recpt 0`
    ss1=`ipmi_sens_number $recpt 1`
    ss2=`ipmi_sens_number $recpt 2`
    ss3=`ipmi_sens_number $recpt 3`
    ss4=`ipmi_sens_number $recpt 4`
    ss5=`ipmi_sens_number $recpt 5`
    ss6=`ipmi_sens_number $recpt 6`
    ss7=`ipmi_sens_number $recpt 7`
    
    file=`basename $templ | sed -e "s/XX/$xx/" -e "s/tpl/inc/"`

    echo -en "$path/$file from $templ with r=$xx, n=$yy..."
    cat $templ | sed \
                 -e "s/XX/$xx/g"\
                 -e "s/YY/$yy/g"\
                 -e "s/SS0/$ss0/g"\
                 -e "s/SS1/$ss1/g"\
                 -e "s/SS2/$ss2/g"\
                 -e "s/SS3/$ss3/g"\
                 -e "s/SS4/$ss4/g"\
                 -e "s/SS5/$ss5/g"\
                 -e "s/SS6/$ss6/g"\
                 -e "s/SS7/$ss7/g" > $path/$file
    echo -e "done"
    recpt=$(($recpt + 1))
done

