static char *usage_msg =
"\n"
"   Options:\n"
"     -i                               ..  I2C slave address\n"
"     -a io addr                       ..  read IO address \n"
"     -a io addr -v value              ..  write value to IO address \n"
"     -I                               ..  select integer address input\n"
"     -b                               ..  burst mode\n"
"\n";

#define CONFIG_CROSS
#if ! defined(__OPTIMIZE__)
#warning  You must compile this program with the correct options!
#warning  See the last lines of the source file.
#error You must compile this driver with "-O".
#endif

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <errno.h>
#include <getopt.h>
#if defined(__powerpc__)
/*#if defined(__linux__)  &&  __GNU_LIBRARY__ == 1*/
#include <asm/io.h>			/* Newer libraries use <sys/io.h> instead. */
#else
#include <sys/io.h>
//#endif
#endif

#include <linux/i2c.h>
#include <linux/i2c-dev.h>

#include <lara.h>

void print_version(void);


int do_read_i2c = 0;
int do_write_i2c = 0;
int silent_write = 0;
int tft_con = 0;
int adc_con = 0;
int do_init_ragnar = 0;
int do_integer_scan = 0;
int do_info_print = 0;
int do_read_video = 0;
int do_write_video = 0;
int do_smbusread = 0;

int	i2c_addr = 0;
int	reg_addr = 0;
int 	reg_val  = 0;
int     i2c_burstlen = 1;

void print_version(void){

	printf("%s: %s (c) 2001 PEPPERCON AG info@peppercon.com\n",__FILE__,__DATE__);
	
}

void print_info(int fd, int i2c_addr)
{
	
}


#define 	LARA_VIDEO_SIZE	(1024)
#define 	PRINT_VIDEO_SIZE	(0x100)
#define 	VIDEO_BLOCKS	(512 * 8)
static u_char g_data[LARA_VIDEO_SIZE];
static int lara_fd = -1;


fb_info_t info;

void dump_video(void)
{
    fb_chunk_t chunk;
    int i;
    unsigned int vhs_time;
    unsigned int vvs_time;
    
    unsigned int offset;
    unsigned int value = 0x00000005;
    unsigned int * valptr;
    offset = reg_addr;
    
    info.depth		= 32;
    info.bpp		= 32;
    info.red_bits	= 8;
    info.green_bits	= 8;
    info.blue_bits	= 8;
    info.g_w		= 1024;
    info.g_wb		= info.g_w * 
			  ((info.bpp + 7) / 8);
    info.g_h		= 768;
    info.is_graphics=1;

    
    
    chunk.len  = LARA_VIDEO_SIZE;
    chunk.data = g_data;

    valptr = (unsigned long *) g_data;

#if 0
    for (i=0;i<LARA_VIDEO_SIZE/4;i++){
    	*(valptr) = 0xBBBBBB00;
    	valptr++;
    }
#endif
    memset(g_data, 0, LARA_VIDEO_SIZE);

    if ((lara_fd = open("/dev/lara", O_RDWR)) == -1) {
	printf("Error opening /dev/lara\n");
    }

#if 0
    for (i=0;i<VIDEO_BLOCKS;i++){
    	    chunk.fb_offset = (i*LARA_VIDEO_SIZE);
	    if (ioctl(lara_fd, ERICIOCINJECTVGACHUNK, &chunk) == -1) {
		if (errno != EAGAIN) {
			printf("Error writing Video mem\n");
		}
	    }
    }
    printf("Offset %x\n", chunk.fb_offset);
#endif
    if (ioctl(lara_fd, ERICIOCSETFBINFO, &info) == -1) {
	if (errno != EAGAIN) {
		printf("Error setting Video mode\n");
	}
    }


    if (ioctl(lara_fd, ERICIOCGETVIDEOHSYNC, &vhs_time) == -1) {
	if (errno != EAGAIN) {
		printf("Error reading VHS timing \n");
	}
    }

    printf("VHS timing %i \n", vhs_time);


    if (ioctl(lara_fd, ERICIOCGETVIDEOVSYNC, &vvs_time) == -1) {
	if (errno != EAGAIN) {
		printf("Error reading VVS timing \n");
	}
    }

    printf("VVS timing %i \n", vvs_time);

    chunk.fb_offset = offset;
    chunk.len  = PRINT_VIDEO_SIZE;

    if (ioctl(lara_fd, ERICIOCDUMPVGAHIGHMEMCHUNK, &chunk) == -1) {
	if (errno != EAGAIN) {
		printf("Error reading Video mem\n");
	}
    }
	for (i=0;i<PRINT_VIDEO_SIZE;i++){
		if ((i%16) == 0) printf("\n %04X:",i+offset);
		printf(" %02X",chunk.data[i]);
	}
	printf("\n");
    
    if (lara_fd != -1) {
	close(lara_fd);
	lara_fd = -1;
    }

}


int
main(int argc, char ** argv)
{
	int    fd,i;
	volatile char * fb;
	int errflag = 0, show_version = 0;
	int c;
	extern char *optarg;
	char *endptr;
	unsigned char invalue;
	unsigned char buf[4096];
	
	
	int adapter_nr = 0; 	/* probably dynamically determined */
  	char filename[20];

	__u8 reg = 0x10; /* Device register to access */
	__s32 res;
	
	int retval=0;


	while ((c = getopt(argc, argv, "a:v:i:sI?b:mr"))
		   != -1)
		switch (c) {
		case 'a': 	do_read_i2c++;
				if (do_integer_scan)
					reg_addr = strtol(optarg, &endptr, 10);
				else
					reg_addr = strtol(optarg, &endptr, 16);
#if 0
				if (	(optarg[0] == '-') || !((optarg != '\0') && (*endptr == '\0')) || errno ||
					(optarg == NULL) || (*optarg == '\0')) {
						printf("reg_addr: %x\n",reg_addr);
					errflag++;
				}
#endif
				break;		
                case 'v':	do_write_i2c++; 
				reg_val = strtoul(optarg, &endptr, 16);
				if (	(optarg[0] == '-') || !((optarg != '\0') && (*endptr == '\0')) || errno ||
                                        (optarg == NULL) || (*optarg == '\0')) {
						printf("reg_val: %x\n",reg_val);
		                                errflag++;
				}
				break;
		case 's': 	silent_write++;
				break;
		case 'i': 	i2c_addr = strtol(optarg, &endptr, 16);
				break;
		case 'I': 	do_integer_scan=1;
				break;
		case 'b': 	i2c_burstlen = strtol(optarg, &endptr, 16);
				break;
		case 'm': 	do_smbusread=1;
				break;
		case 'r':	do_read_video=1;
				break;
		case '?':
			errflag++;
		}
	
	if (errflag) {
		printf(usage_msg);
		return 3;
	}
 	

  	/* Read out Video buffer */

	if (do_read_video){
		dump_video();
		exit(0);
	}

  	/* Open the I2C interface */
  	
  	sprintf(filename,"/dev/i2c-%d",adapter_nr);
  	if ((fd = open(filename,O_RDWR)) < 0) {
    		/* ERROR HANDLING; you can check errno to see what went wrong */
		fprintf(stderr, "Error Opening I2C device %i.\n",errno);
		exit(1);
  	}

  	/* Read or write AD9888 or SAA6721 registers */

	if (i2c_addr){
	
	  	if (ioctl(fd,I2C_SLAVE,i2c_addr) < 0) {
	    		/* ERROR HANDLING; you can check errno to see what went wrong */
	    		fprintf(stderr, "IOCTL I2C device %i.\n",errno);
	    		exit(1);
	  	}
	      	if (silent_write == 0) printf("I2C Addr: 0x%02x\n",i2c_addr);

		if (do_read_i2c && !do_write_i2c) {
			printf("Reg 0x%02x: 0x%02x\n",reg_addr, i2c_smbus_read_byte_data(fd,reg_addr));
			if (do_write_i2c == 0) return 0;
		}
		
		if (do_read_i2c && do_write_i2c) {
			i2c_smbus_write_byte_data(fd,reg_addr,reg_val);
			if (silent_write == 0) 
				printf("Reg 0x%02x: 0x%02x\n",reg_addr, i2c_smbus_read_byte_data(fd,reg_addr));
			return 0;
		}
		if (do_info_print){
			print_info(fd, i2c_addr);
		}
		
	}
#if 0
	if (i2c_addr){
	
	  	if (ioctl(fd,I2C_SLAVE,i2c_addr) < 0) {
	    		/* ERROR HANDLING; you can check errno to see what went wrong */
	    		fprintf(stderr, "IOCTL I2C device %i.\n",errno);
	    		exit(1);
	  	}
	      	
	      	if (do_smbusread == 1){
			printf("Reg 0x%02x: 0x%02x\n",reg_addr, i2c_smbus_read_byte_data(fd,reg_addr));
			if (do_write_i2c == 0) return 0;

	      	}
	      	else{
	      	
		      	buf[0] = reg_addr;
		      	
		      	if (silent_write == 0) printf("I2C Addr: 0x%02x\n",i2c_addr);
	
			if (do_read_i2c && !do_write_i2c) {
	
				if (write(fd,buf,2) != 2) {
    					printf("Error during plain I2C write\n");
  				} 	
  				else {
  				}
	
				if (read(fd,buf,2) != 2) {
    					printf("Error during plain I2C read\n");
  				} else {
    					printf("Reg 0x%02x: 0x%02x\n",reg_addr, buf[0]);
  				}
				
				if (do_write_i2c == 0) return 0;
			}
		}		
		if (do_read_i2c && do_write_i2c) {
			
			buf[1] = (unsigned char) reg_val;
			buf[2] = (unsigned char) (reg_val>>8);
			
			if ( (retval = write(fd,buf,(i2c_burstlen+1))) != (i2c_burstlen + 1)) {
       				printf("Error during plain I2C write %i\n", retval);
    			}
			else{
				if (silent_write == 0) 
					printf("Reg 0x%02x: 0x%02x\n",reg_addr, i2c_smbus_read_byte_data(fd,reg_addr));
				return 0;
			}
			if (i2c_burstlen > 1){

				for (i=0;i<10;i++){
					if ( (retval = write(fd,buf,(i2c_burstlen+1))) != (i2c_burstlen + 1)) {
		       				printf("Error during plain I2C write %i\n", retval);
		    			}
		    		}
			}
		}
		if (do_info_print){
			print_info(fd, i2c_addr);
		}
		
	}
#endif
	close(fd);
}


