/***************************************************************************** 
 * This file contains definitions for the AD9888 ADC controller.
 *
 * Copyright (c) 2002 Peppercon AG
 *
 * Swen Anderson, sand@peppercon.com
 *
 * All rights reserved.
 *
 * $Id: tda9888.h,v 1.1.1.1 2002/06/13 16:19:43 miba Exp $
 ****************************************************************************/

#ifndef _AD9888_H
#define _AD9888_H

#define 	I2C_ADDRESS_AD9888			0x4C

#define 	AD9888_CHIPREV				0x00
#define 	AD9888_PLL_DIV_MSB			0x01
#define 	AD9888_PLL_DIV_MSB_VALUE		0x42
#define 	AD9888_PLL_DIV_LSB			0x02
#define 	AD9888_PLL_DIV_LSB_VALUE		0x00

#define 	AD9888_VCO_CPMP			0x03
#define 	AD9888_VCO_CPMP_CURRENT		(0x05<<3)
#define 	AD9888_VCO_CPMP_VCO_RANGE		(0x00<<6)
#define 	AD9888_VCO_CPMP_VALUE			(AD9888_VCO_CPMP_CURRENT | AD9888_VCO_CPMP_VCO_RANGE)


#define 	AD9888_PHASE_ADJUST			0x04
#define 	AD9888_CLAMP_PLASEMENT			0x05
#define 	AD9888_CLAMP_PLASEMENT_VALUE		8     // 8
#define 	AD9888_CLAMP_DURATION			0x06
#define 	AD9888_CLAMP_DURATION_VALUE		20    // 20
#define 	AD9888_HSYNC_O_PULSE			0x07
#define 	AD9888_HSYNC_O_PULSE_VALUE		0x20  //0x20
#define 	AD9888_RED_GAIN			0x08
#define 	AD9888_RED_GAIN_VALUE			0xb0  //0xb0
#define 	AD9888_GREEN_GAIN			0x09
#define 	AD9888_GREEN_GAIN_VALUE		0xb0
#define 	AD9888_BLUE_GAIN			0x0A
#define 	AD9888_BLUE_GAIN_VALUE			0xb0

#define 	AD9888_RED_OFFSET			0x0B
#define 	AD9888_RED_OFFSET_VALUE		0xb0
#define 	AD9888_GREEN_OFFSET			0x0C
#define 	AD9888_GREEN_OFFSET_VALUE		0xb0
#define 	AD9888_BLUE_OFFSET			0x0D
#define 	AD9888_BLUE_OFFSET_VALUE		0xb0

#define 	AD9888_SYNC_CONTROL			0x0E
#define 	AD9888_SYNC_CONTROL_HSYNCI_POL_SET	0x80
#define 	AD9888_SYNC_CONTROL_HSYNCI_POL_HIGH	0x40
#define 	AD9888_SYNC_CONTROL_HSYNCO_POL_LOW	0x20
#define 	AD9888_SYNC_CONTROL_ACT_HSYNC_SET	0x10
#define 	AD9888_SYNC_CONTROL_ACT_HSYNC_SOG	0x08
#define 	AD9888_SYNC_CONTROL_VSYNCO_POL_INV	0x04
#define 	AD9888_SYNC_CONTROL_ACT_VSYNC_SET	0x02
#define 	AD9888_SYNC_CONTROL_ACT_VSYNC_SSV	0x01

#define 	AD9888_CLAMP_CONTROL			0x0F
#define 	AD9888_CLAMP_CONTROL_STOP_PWRDOWN	0x02
#define 	AD9888_CLAMP_CONTROL_ALLOW_PWRDOWN	0x04
#define 	AD9888_CLAMP_CONTROL_EXT_COAST_HIGH	0x08
#define 	AD9888_CLAMP_CONTROL_COAST_POL_MAN	0x10
#define 	AD9888_CLAMP_CONTROL_COAST_VSYNC	0x20
#define 	AD9888_CLAMP_CONTROL_CLAMP_HIGH	0x40
#define 	AD9888_CLAMP_CONTROL_EXT_CLAMP		0x80

#define 	AD9888_SOG_TRESHOLD			0x10
#define 	AD9888_SS_TRESHOLD			0x11

#define 	AD9888_PRE_COAST			0x12
#define 	AD9888_PRE_COAST_VALUE			0x00
#define 	AD9888_POST_COAST			0x13
#define 	AD9888_POST_COAST_VALUE		0x00

#define 	AD9888_SYNC_DETECT			0x14
#define 	AD9888_GENERAL_MODE			0x15
#define 	AD9888_GENERAL_MODE_PLL_OFF		0x01
#define 	AD9888_GENERAL_MODE_BW_75MHZ		(0x0<<1)
#define 	AD9888_GENERAL_MODE_BW_150MHZ		(0x1<<1)
#define 	AD9888_GENERAL_MODE_BW_300MHZ		(0x2<<1)
#define 	AD9888_GENERAL_MODE_BW_500MHZ		(0x3<<1)
#define 	AD9888_GENERAL_MODE_INP_CHANNEL1	0x08

#define 	AD9888_GENERAL_MODE_FORMAT_422		0x10
#define 	AD9888_GENERAL_MODE_PORTB_FIRST	0x20
#define 	AD9888_GENERAL_MODE_PARALLEL		0x40
#define 	AD9888_GENERAL_MODE_DUAL_CHANNEL	0x80

#define 	AD9888_TEST_REG1			0x16
#define 	AD9888_TEST_REG2			0x17
#define 	AD9888_TEST_REG3			0x18
#define 	AD9888_TEST_REG4			0x19

#endif /* _AD9888_H */
