#include <time.h>

/* Typedefs */
typedef unsigned char BYTE;
typedef unsigned char byte;
typedef unsigned int  WORD;
typedef unsigned int  word;
typedef unsigned int  UINT;
typedef unsigned long ULONG;
typedef unsigned long DWORD;
typedef unsigned long dword;
typedef int BOOL;

#define MIN	__min
#define MAX __max

#define SEGMENT_OF(s)	((UINT)((s) >> 16))

/* Boolean values */
#define TRUE 1
#define FALSE 0

/* Device Addresses */
#define BMC_DEV_ADDR          0x20
#define HSC0_DEV_ADDR         0xC0
#define HSC1_DEV_ADDR         0xC2
#define PSC_DEV_ADDR          0xC8

/* Max. command/data length */
#define MAX_PACKET_LEN        1200 //0x20

/* LUNs */
#define SMS_LUN               0x02

//
// Channel Ids
//
#define IPMB_CHANNEL_ID		0
//
// Structure of an IPMB message
//
typedef struct
{
	byte rsSa;
	byte netFnRsLn;
#define		NETFN_OF(nl)	(((nl) >> 2) & 0x3F)
#define		LUN_OF(nl)		((nl) & 0x3)

	byte cSum1;
	byte rqSa;
	byte seqRqLn;
#define		SEQ_OF(sl)	(((sl) >> 2) & 0x3F)

	byte cmd;
	byte data[1];
	// last byte of data is the second checksum
} IpmbMsg_t;
//
// Structure of a BMC request
//
typedef struct
{
	byte netFnLn;
	byte cmd;
	byte data[MAX_PACKET_LEN];
} BmcReq_t;

#define MIN_BMC_REQ_SIZE	2

typedef struct
{
	int		length;		// length of data in bmcReq (not including netFn/cmd).
	byte		ipmbAddr;	// slave address to send request to
	BmcReq_t	bmcReq;		// body of request
} MicroReq_t;
//
// Structure of a BMC response
//
typedef struct
{
	byte netFnLn;
	byte cmd;
	byte cCode;
	byte data[MAX_PACKET_LEN];
	
} BmcResp_t;

#define MIN_BMC_RESP_SIZE	3

typedef struct
{
	int		respLen;	// bmcResp data length only
	byte		ipmbAddr; 
	BmcResp_t	bmcResp;
	
} MicroResp_t;

#define PrintBmcReq( n, r, l )		PrintBuffer( (n), (byte *)(r), (l) )
#define PrintMicroReq( n, r )	PrintBuffer( (n), (byte *)&((r)->bmcReq), (r)->length + MIN_BMC_REQ_SIZE )

#ifndef INTERFACE_PRIVATE

typedef void * InterfaceHandle;

#endif // INTERFACE_PRIVATE
//
// Interface function vector
//
typedef struct _InterfaceApi
{
	void	(*configure)( InterfaceHandle intf, WORD address );
	WORD	(*capabilities)( InterfaceHandle intf );
#define			IF_IPMB_ACCESS	0x01

	byte	(*bmcAddr)( InterfaceHandle intf );
	void	(*setTimeout) ( InterfaceHandle intf, int which, int what );
	int		(*sendRequest)( InterfaceHandle intf, BmcReq_t *req, int length );
	int		(*readResponse)( InterfaceHandle intf, BmcResp_t *resp );
	int		(*smsReady)( InterfaceHandle intf );
	clock_t	(*lastReqTime)( InterfaceHandle intf );
	char *	name;

} InterfaceApi;

//
// I2C Bus numbers (LSB==0 means public, LSB==1 means private)
//
#define PUBLIC_I2C_BUS              0x00
#define PRIMARY_PRIVATE_I2C_BUS     0x01
#define SECONDARY_PRIVATE_I2C_BUS   0x03

//
// Maximum possible I2C address
//
#define MAX_I2C_ADDRESS       0xFE

//
// Mask off LSBit of I2C address 
//
#define I2C_MASK              0xFE

//
// IPMI version numbers
//
#define IPMI_1_0	0x10
#define IPMI_0_9	0x09
//
// Network Functions (NetFn) already shifted 2 bits
//
#define CHASSIS_REQUEST       0x00
#define CHASSIS_RESPONSE      0x04
#define BRIDGE_REQUEST        0x08
#define BRIDGE_RESPONSE       0x0C
#define SENSOR_EVENT_REQUEST  0x10
#define SENSOR_EVENT_RESPONSE 0x14
#define APP_REQUEST           0x18
#define APP_RESPONSE          0x1C
#define FW_REQUEST            0x20
#define FW_RESPONSE           0x24
#define STORAGE_REQUEST       0x28
#define STORAGE_RESPONSE      0x2C

//
// Application commands 
//
#define GET_DEVICE_ID            0x01
#define COLD_RESET               0x02
#define DISABLE_PROCESSOR        0x32
#define GET_MESSAGE		         0x33
#define SEND_MESSAGE	         0x34
#define READ_SMS_MESSAGE_BUFFER  0x37
#define MASTER_WRITE_I2C         0x50
#define MASTER_READ_I2C          0x51
#define MASTER_WRITE_READ_I2C    0x52
#define DUMP_TASK                0x5D

//
// Sensor event commands
//
#define PLATFORM_EVENT_MESSAGE      0x02
#define GET_SENSOR_HISTERISIS       0x25
#define GET_SENSOR_THRESHOLD        0x27
#define GET_SENSOR_EVENT_STATUS     0x2B
#define GET_SENSOR_READING          0x2D

//
// Storage commands
//
#define GET_FRU_INVENTORY_AREA_INFO 0x10
#define READ_FRU_INVENTORY_DATA     0x11
#define WRITE_FRU_INVENTORY_DATA    0x12
#define READ_BMC_MEMORY             0x1B
#define RESERVE_SDR_REPOSITORY      0x22
#define GET_SDR                     0x23
#define PARTIAL_ADD_SDR             0x25
#define CLEAR_SDR_REPOSITORY        0x27
#define RESERVE_SEL_REPOSITORY      0x42
#define GET_SEL                     0x43
#define ADD_SEL_ENTRY               0x44
#define PARTIAL_ADD_SEL             0x45
#define CLEAR_SEL                   0x47
#define GET_SEL_TIME                0x48

//
// FW transfer commands
//
#define ENTER_FW_TRANSFER			0x00
#define FW_PROGRAM_MEMORY			0x01
#define FW_READ_MEMORY				0x02
#define GET_FW_CHECKSUM				0x03
#define EXIT_FW_TRANSFER			0x04
#define SET_SEGMENT					0x05

/* Add SEL add operations */
#define APPEND_RECORD            0x00
#define REPLACE_RECORD           0x01

/* Partial add progress states */
#define PARTIAL_ADD_IN_PROGRESS  0x00
#define LAST_RECORD_DATA         0x01

/* Completion codes */
#define COMPCODE_NORMAL             0x00
#define COMPCODE_NODEBUSY           0xC0
#define COMPCODE_INVALIDCMD         0xC1
#define COMPCODE_INVALIDLUN         0xC2
#define COMPCODE_TIMEOUT            0xC3
#define COMPCODE_OUTOFSPACE         0xC4
#define COMPCODE_RESVTNCNCLD        0xC5
#define COMPCODE_REQDATATRUNC       0xC6
#define COMPCODE_REQDATABADLEN      0xC7
#define COMPCODE_REQDATATOOLONG     0xC8
#define COMPCODE_OFFSETOUTOFRANGE   0xC9
#define COMPCODE_RESPDATATRUNC      0xCA
#define COMPCODE_NOTFOUND           0xCB
#define COMPCODE_INVALIDFIELD       0xCC
#define COMPCODE_COMMANDILLEGAL     0xCD
#define COMPCODE_NORESPONSE         0xCE
#define COMPCODE_UNSPECIFIED        0xFF

/* I2C Completion Codes */
#define I2C_WRITE_STATUS_NORMAL        0x00
#define I2C_WRITE_STATUS_LOST_ARB      0x01
#define I2C_WRITE_STATUS_BUS_ERROR     0x02
#define I2C_WRITE_STATUS_NAK_WRITE     0x03
#define I2C_WRITE_STATUS_TRUNC_READ    0x04
#define I2C_WRITE_STATUS_NAK_ADDRESS   0x05
#define I2C_WRITE_STATUS_BAD_LENGTH    0x06
#define I2C_READ_STATUS_NORMAL         0x00

/* Request Packet Offsets */
#define REQ_OFFSET_NETFN    0x00
#define REQ_OFFSET_CMD      0x01
#define REQ_OFFSET_DATA     0x02

/* Response Packet Offsets */
#define RSP_OFFSET_ADDR     0x00
#define RSP_OFFSET_NETFN    0x01
#define RSP_OFFSET_CMD      0x02
#define RSP_OFFSET_COMPCODE 0x03
#define RSP_OFFSET_DATA     0x04

/* IMB Response Packet Offsets */
#define IMB_RSP_OFFSET_RQADDR     0x00
#define IMB_RSP_OFFSET_NETFN      0x01
#define IMB_RSP_OFFSET_CKSUM      0x02
#define IMB_RSP_OFFSET_RSADDR     0x03
#define IMB_RSP_OFFSET_RQSEQRSLUN 0x04
#define IMB_RSP_OFFSET_CMD        0x05
#define IMB_RSP_OFFSET_COMPCODE   0x06
#define IMB_RSP_OFFSET_DATA       0x07

/* Timeout(s) */
#define SMS_TIMEOUT  20000 //4000

#define dprintf	if( Debug ) fprintf
#define vprintf	if( Verbose ) fprintf
//
// This structure defines the response from a Get Device Id command (IPMI 1.0)
//
typedef struct
{
	BYTE	devId;
	BYTE	devRev;
#define				PROVIDES_DEV_SDRS	0x80
	BYTE	fwMajRev;
#define				FW_MODE				0x80
#define				FW_MODE_UPDATE		0x80
#define				FW_MODE_OPERATIONAL	0x00
	BYTE	fwMinRev;
	BYTE	ipmiVer;
	BYTE	devSupport;
#define				IPM_CHASSIS_DEV		0x80
#define				IPM_BRIDGE			0x40
#define				IPM_EVENT_GEN		0x20
#define				IPM_EVENT_RECV		0x10
#define				IPM_FRU_DEV			0x08
#define				IPM_SEL_DEV			0x04
#define				IPM_SDR_DEV			0x02
#define				IPM_SENSOR_DEV		0x01
	BYTE	mfgId[3];
	BYTE	prodId[2];
} DevInfo;

//
// function prototypes
//
BOOL			FindInterface ( char * intfName );
int				SendRequestToMicro( MicroReq_t *, MicroResp_t * );
int				ReadResponseFromMicro( MicroResp_t * );
int				BroadcastRequestToMicro( MicroReq_t *, MicroResp_t * );

InterfaceHandle	InterfaceInit ( char * intfName );
int				SendRequest( InterfaceHandle intf, MicroReq_t *, MicroResp_t *, BYTE );
int				ReadResponse( InterfaceHandle intf, MicroResp_t * );
clock_t			LastReqTime( void );

void SetIPMIversion( byte vers );

void SleepMs(UINT);
BOOL CheckMsTimeout(clock_t);
void SetMsTimeout(clock_t *, UINT );
void ChecksumRecord(BYTE * , UINT );
UINT CheckCompletionCode(BYTE );
BOOL BusExists(BYTE);
void usDelay(WORD);
void msDelay(WORD);

void PrintStandardDisclaimer(void);

BYTE PingI2C(BYTE , BYTE );

//
// Global variables
//
extern BYTE Debug;
extern BYTE Verbose;
//extern BYTE seqNum;
extern WORD gIPMBRespTimeInMS;
extern ULONG gIPMBTryCount;
extern ULONG gNAKWCount;
extern ULONG gNAKACount;
extern ULONG gLARBCount;
extern ULONG gBERRCount;
extern ULONG gSMSTOCount;
