//
// Default SMS and SMM interface addresses
//
#define ISA_SMS_DATA          0xCA2
#define ISA_SMS_CMD_STATUS    0xCA3

#define ISA_SMM_DATA          0xCA4
#define ISA_SMM_CMD_STATUS    0xCA5

/* State bits based on S1 & S0 below */

#define ISA_STATE_MASK        0xC0
#define ISA_IDLE_STATE        0x00
#define ISA_READ_STATE        0x40
#define ISA_WRITE_STATE       0x80
#define ISA_ERROR_STATE       0xC0

/* Status Register Bits */
#define ISA_S1_FLAG           0x80
#define ISA_S0_FLAG           0x40
/* RESERVED                   0x20 */
/* RESERVED                   0x10 */
#define ISA_CD_FLAG           0x08
#define ISA_SMS_MSG_FLAG      0x04
#define ISA_IBF_FLAG          0x02
#define ISA_OBF_FLAG          0x01
//
// ISA interface register access defines
//
#define ISA_OBF(a)					((BYTE)(_inp(a+1) & ISA_OBF_FLAG))
#define ISA_IBF(a)					((BYTE)(_inp(a+1) & ISA_IBF_FLAG))
#define ISA_MSG(a)					((BYTE)(_inp(a+1) & ISA_SMS_MSG_FLAG))
#define ISA_STATE(a)				((BYTE)(_inp(a+1) & ISA_STATE_MASK))
#define ISA_STATUS(a)				((BYTE)(_inp(a+1)))
#define ISA_READ_BMC_DATA(a)		((BYTE)(_inp(a)))
#define ISA_WRITE_BMC_DATA(a,x)		(_outp(a,(unsigned)x))
#define ISA_WRITE_BMC_CMD(a,x)		(_outp(a+1,(unsigned)x))

 /* SMS Transfer Stream Control Codes */
                                
#define ISA_GET_STATUS_ABORT   0x60
#define ISA_WRITE_START        0x61
#define ISA_WRITE_END          0X62
#define ISA_READ               0X68

#define BMC_SLAVE_ADDR 0x20                                 
#define MAX_ISA_LENGTH  1200 //35

#define ISA_SMS_TIMEOUT 20000 //5000	// in miliseconds - 1 second
#define ISA_SMM_TIMEOUT	10000 //100		// in microseconds

//
// This function is a factory that tests the string arg to see if it is an ISA
// interface name and then searches for the interface on the platform. If NULL is
// passed in, then it searches for any ISA interface in its default list.
//
InterfaceHandle IsaIntfPresent( char * str );
