/*----------------------------------------------------------
* Copyright (c) 2002 by National Semiconductor Corporation
* All rights reserved.
*-----------------------------------------------------------
* File Contents:
*     PCI related definitions
* Project:  PC87431x
*---------------------------------------------------------*/
#define PCI_CONFIG_ADDRESS  0xCF8
#define PCI_CONFIG_DATA     0xCFC


#define PCIC_OUT_32(_pdev,_port,_data)  ( out_32(PCI_CONFIG_ADDRESS,_pdev+(_port&0xFFC)), out_32(PCI_CONFIG_DATA+(_port&3),_data) )
#define PCIC_OUT_16(_pdev,_port,_data)  ( out_32(PCI_CONFIG_ADDRESS,_pdev+(_port&0xFFC)), out_16(PCI_CONFIG_DATA+(_port&3),_data) )
#define PCIC_OUT_8(_pdev,_port,_data)   ( out_32(PCI_CONFIG_ADDRESS,_pdev+(_port&0xFFC)), out_8 (PCI_CONFIG_DATA+(_port&3),_data) )

#define PCIC_IN_32(_pdev,_port)         ( out_32(PCI_CONFIG_ADDRESS,_pdev+(_port&0xFFC)), in_32(PCI_CONFIG_DATA+(_port&3)) )
#define PCIC_IN_16(_pdev,_port)         ( out_32(PCI_CONFIG_ADDRESS,_pdev+(_port&0xFFC)), in_16(PCI_CONFIG_DATA+(_port&3)) )
#define PCIC_IN_8(_pdev,_port)          ( out_32(PCI_CONFIG_ADDRESS,_pdev+(_port&0xFFC)), in_8 (PCI_CONFIG_DATA+(_port&3)) )

#define VENDOR_ID               0x00
#define COMMAND                 0x04
  #define IO_SPACE              (1 << 0)
  #define MEM_SPACE             (1 << 1)
  #define BUS_MASTER            (1 << 2)
  #define SPECIAL_CYCLES        (1 << 3)
  #define MEM_WR_INVALIDATE     (1 << 4)
  #define VGA_PALETTE_SNOOP     (1 << 5)
  #define PARITY_RESPONSE       (1 << 6)
  #define WAIT_CYCLE_CONTROL    (1 << 7)
  #define SERR_ENABLE           (1 << 8)
  #define FAST_BACK_TO_BACK     (1 << 9)
#define STATUS              0x06
#define REVISION_ID         0x08
#define CACHE_LINE          0x0C
#define INTERRUPT_LINE      0x3C

/* PCI unique identifiers */
#define ID_8111             0x746A1022
#define ID_81801            0x24128086
#define ID_81801AA          0x24138086
#define ID_81801AB          0x24238086
#define ID_82801BA          0x24438086
#define ID_82801CA          0x24838086
#define ID_ICH4             0x24C38086
#define ID_ICH5             0x24D38086
#define ID_CSB5             0x02011166
#define ID_CSB6             0x02031166
#define ID_OSB4             0x02001166
#define Hance_Rapids		0x25A48086		//lester 0627

/*
 * PCI configuration registers
 */
#define  ICH_SMB_BASE                 0x20   /* base address register */
#define  ICH_HOSTC                    0x40   /* host config register */
#define  ICH_HOSTC_I2C_EN             0x04   /* enable i2c mode */
#define  ICH_HOSTC_SMB_SMI_EN         0x02   /* SMI# instead of irq */
#define  ICH_HOSTC_HST_EN             0x01   /* enable host cntrlr */

#define  AMD_SMB_BASE_2               0x10    /* base address register of SMBus 2.0*/
#define  AMD_SMB_BASE_2_EN            0x04    /* SMBus 2.0 space enable*/
#define  AMD_SMB_BASE_1               0x58    /* base address register  of SMBus 1.0*/
#define  AMD_SMB_BASE_1_EN            0x41    /* SMBus 1.0 space enable */
#define  AMD_SMBUS_1                  0xE0    /* SMBus 1.0 registers */

/*
 * I/O registers
 */
#define ICH_HST_STA                     0x00    /* host status */
#define   ICH_HST_STA_BYTE_DONE_STS     0x80    /*   byte send/rec'd */
#define   ICH_HST_STA_INUSE_STS         0x40    /*   device access mutex */
#define   ICH_HST_STA_SMBALERT_STS      0x20    /*   SMBALERT# signal */
#define   ICH_HST_STA_FAILED            0x10    /*   failed bus transaction */
#define   ICH_HST_STA_BUS_ERR           0x08    /*   transaction collision */
#define   ICH_HST_STA_DEV_ERR           0x04    /*   misc. smb device error */
#define   ICH_HST_STA_ALL_ERRS          (ICH_HST_STA_FAILED|ICH_HST_STA_BUS_ERR|ICH_HST_STA_DEV_ERR)
#define   ICH_HST_STA_INTR              0x02    /*   command completed ok */
#define   ICH_HST_STA_HOST_BUSY         0x01    /*   command is running */
#define ICH_HST_CNT                     0x02    /* host control */
#define   ICH_HST_CNT_START             0x40    /*   start command */
#define   ICH_HST_CNT_LAST_BYTE         0x20    /*   indicate last byte */
#define   ICH_HST_CNT_SMB_CMD_QUICK     0x00    /*   command: quick */
#define   ICH_HST_CNT_SMB_CMD_BYTE      0x04    /*   command: byte */
#define   ICH_HST_CNT_SMB_CMD_BYTE_DATA 0x08    /*   command: byte data */
#define   ICH_HST_CNT_SMB_CMD_WORD_DATA 0x0c    /*   command: word data */
#define   ICH_HST_CNT_SMB_CMD_PROC_CALL 0x10    /*   command: process call */
#define   ICH_HST_CNT_SMB_CMD_BLOCK     0x14    /*   command: block */
#define   ICH_HST_CNT_SMB_CMD_I2C_READ  0x18    /*   command: i2c read */
#define   ICH_HST_CNT_KILL              0x02    /*   kill current transaction */
#define   ICH_HST_CNT_INTREN            0x01    /*   enable interrupt */
#define ICH_HST_CMD                     0x03    /* host command */
#define ICH_XMIT_SLVA                   0x04    /* transmit slave address */
#define   ICH_XMIT_SLVA_READ            0x01    /*   direction: read */
#define   ICH_XMIT_SLVA_WRITE           0x00    /*   direction: write */
#define ICH_D0                          0x05    /* host data 0 */
#define ICH_D1                          0x06    /* host data 1 */
#define ICH_BLOCK_DB                    0x07    /* block data byte */

/* SMBus 1.0 */
#define AMD_SMB_1_STATUS                0x00     /* SMBus global status  */
#define     AMD_SMB_1_STATUS_SMBS_BSY    (1<11)
#define     AMD_SMB_1_STATUS_SMBA_STS    (1<10)
#define     AMD_SMB_1_STATUS_HSLV_STS    (1<9)
#define     AMD_SMB_1_STATUS_SNP_STS     (1<8)
#define     AMD_SMB_1_STATUS_TO_STS      (1<5)
#define     AMD_SMB_1_STATUS_HCYC_STS    (1<4)
#define     AMD_SMB_1_STATUS_HST_BSY     (1<3)
#define     AMD_SMB_1_STATUS_PERR_STS    (1<2)
#define     AMD_SMB_1_STATUS_COL_STS     (1<1)
#define     AMD_SMB_1_STATUS_ABRT_STS    (1<0)
#define     AMD_SMB_1_STATUS_ALL_ERRS        AMD_SMB_1_STATUS_TO_STS|AMD_SMB_1_STATUS_HST_BSY|AMD_SMB_1_STATUS_PERR_STS|AMD_SMB_1_STATUS_COL_STS
#define AMD_SMB_1_CTL                  0x02     /* SMBus global control */
#define     AMD_SMB_1_CTL_SMBA_EN      (1<<10)
#define     AMD_SMB_1_CTL_HSLV_EN      (1<<9)
#define     AMD_SMB_1_CTL_SNP_EN       (1<<8)
#define     AMD_SMB_1_CTL_ABORT        (1<<5)
#define     AMD_SMB_HCYC_EN            (1<<4)
#define     AMD_SMB_HOSTSTS            (1<<3)
#define     AMD_SMB_CYCTYPE_QC         0x0     /* quick command */
#define     AMD_SMB_CYCTYPE_RSB        0x1     /* receive/send byte */
#define     AMD_SMB_CYCTYPE_RWB        0x2     /* read/write byte */
#define     AMD_SMB_CYCTYPE_RWW        0x3     /* read/write word */
#define     AMD_SMB_CYCTYPE_PC         0x4     /* process call */
#define     AMD_SMB_CYCTYPE_RWBL       0x5     /* read/write block */
#define AMD_SMB_1_ADDR                 0x04     /* SMBus host address */
#define     AMD_SMB_1_ADDR_READCYC     (1<<0)
#define AMD_SMB_1_DATA                 0x06     /* SMBus host data */
#define AMD_SMB_1_CMD                  0x08     /* SMBus host command */
#define AMD_SMB_1_BLOCK_DATA           0x09     /* SMBus block data FIFO access port */


/* SMBus 2.0 */


#define AMD_SMB_PRTCL        0x00    /* protocol, PEC */
#define AMD_SMB_STS          0x01    /* status */
#define AMD_SMB_ADDR         0x02    /* address */
#define AMD_SMB_CMD          0x03    /* command */
#define AMD_SMB_DATA         0x04    /* 32 data registers */
#define AMD_SMB_BCNT         0x24    /* number of data bytes */
#define AMD_SMB_ALRM_A       0x25    /* alarm address */
#define AMD_SMB_ALRM_D       0x26    /* 2 bytes alarm data */

#define AMD_SMB_STS_DONE     0x80
#define AMD_SMB_STS_ALRM     0x40
#define AMD_SMB_STS_RES      0x20
#define AMD_SMB_STS_STATUS   0x1f

/*
 * ACPI 2.0 chapter 13 PCI interface definitions.
 */

#define AMD_EC_DATA          0x00    /* data register */
#define AMD_EC_SC            0x04    /* status of controller */
#define AMD_EC_CMD           0x04    /* command register */
#define AMD_EC_ICR           0x08    /* interrupt control register */

#define AMD_EC_SC_SMI        0x04    /* smi event pending */
#define AMD_EC_SC_SCI        0x02    /* sci event pending */
#define AMD_EC_SC_BURST      0x01    /* burst mode enabled */
#define AMD_EC_SC_CMD        0x08    /* byte in data reg is command */
#define AMD_EC_SC_IBF        0x02    /* data ready for embedded controller */
#define AMD_EC_SC_OBF        0x01    /* data ready for host */

#define AMD_EC_CMD_RD        0x80    /* read EC */
#define AMD_EC_CMD_WR        0x81    /* write EC */
#define AMD_EC_CMD_BE        0x82    /* enable burst mode */
#define AMD_EC_CMD_BD        0x83    /* disable burst mode */
#define AMD_EC_CMD_QR        0x84   /* query EC */

#define AMD_SMB_BLOCK_WRITE  0xa
#define AMD_SMB_BLOCK_READ   0xb

/* SMBus Controllers */
#define INTEL_SMBC                      1       /* Intel */
#define SW_SMBC                         2       /* ServerWorks */
#define VIA_SMBC                        3       /* VIA */
#define AMD_SMBC                        4       /* AMD */


unsigned long get_PCI_devid(unsigned char dev, unsigned char func);
unsigned char __pascal in_8(unsigned int io_port);
void __pascal out_8(unsigned int io_port, unsigned char io_data);
unsigned long __pascal in_16(unsigned int io_port);
void __pascal out_16(unsigned int io_port, unsigned int io_data);
unsigned long __pascal in_32(unsigned int io_port);
void __pascal out_32(unsigned int io_port, unsigned long io_data);


