;/*----------------------------------------------------------
;* Copyright (c) 2002 by National Semiconductor Corporation
;* All rights reserved.
;*-----------------------------------------------------------
;* File Contents:
;*     This file contains PCI related library functions.
;* Project:  PC87431
;*---------------------------------------------------------*/
.model small,pascal

.486p
.code

PCI_CONFIG_ADDRESS        EQU 0CF8h

; Writes the PCI Config Address
; Input:
;   EAX = config address
; Output:
;    DX = points to 0xCFC/0xCFD/0xCFE/0xCFE
PCI_Common  proc

	mov	dx, PCI_CONFIG_ADDRESS
	out	dx, eax
	add	dl, 4			; PCI_CONFIG_PCI_Config_Addr + 2 LSBs
	and	al, 3
	add	dl, al
	ret

PCI_Common endp



read_PCI_byte proc c PCI_Config_Addr:DWORD

	mov	eax, [PCI_Config_Addr]
	call	PCI_Common
	in	al, dx
	ret

read_PCI_byte endp


read_PCI_word proc c \
	PCI_Config_Addr:DWORD

	mov	eax, [PCI_Config_Addr]
	call	PCI_Common
	in	ax, dx
	ret

read_PCI_word endp


read_PCI_dword proc c \
	PCI_Config_Addr:DWORD

	mov	eax, [PCI_Config_Addr]
	call	PCI_Common
	in	eax, dx
	mov	edx, eax
	shr	edx, 16
	ret

read_PCI_dword endp


write_PCI_byte proc c \
	PCI_Config_Addr: DWORD, \
	Data: BYTE

	mov	eax, [PCI_Config_Addr]
	call	PCI_Common
	mov	al, [Data]
	out	dx, al
	ret

write_PCI_byte endp


write_PCI_word proc c \
	PCI_Config_Addr:DWORD, \
	Data:WORD

	mov	eax, [PCI_Config_Addr]
	call	PCI_Common
	mov	ax, [Data]
	out	dx, ax
	ret

write_PCI_word endp


write_PCI_dword proc c \
	PCI_Config_Addr:dword, \
	Data:dword

	mov	eax, [PCI_Config_Addr]
	call	PCI_Common
	mov	eax, [Data]
	out	dx, eax
	ret

write_PCI_dword endp

;************************************************************************
;
; 8 bit I/O routines
;
;************************************************************************

in_8 proc  far pascal, io_port:word

    xor eax, eax
	mov	dx, io_port
	in 	al, dx
	mov	edx, eax
	shr	edx, 16
	ret
   
in_8 endp


out_8	proc far pascal,	io_port:word, io_data:byte

	mov	dx, io_port
	mov	al, io_data
	out	dx, al
	ret

out_8	endp

;************************************************************************
;
; 16 bit I/O routines
;
;************************************************************************

in_16 proc  far pascal, io_port:word

    xor eax, eax
	mov	dx, io_port
	in 	ax, dx
	mov	edx, eax
	shr	edx, 16
	ret
   
in_16 endp


out_16	proc far pascal,	io_port:word, io_data:word

	mov	dx, io_port
	mov	ax, io_data
	out	dx, ax
	ret

out_16	endp


;************************************************************************
;
; 32 bit I/O routines
;
;************************************************************************

in_32 proc  far pascal, io_port:word

	mov	dx, io_port
	in 	eax, dx
	mov	edx, eax
	shr	edx, 16
	ret
   
in_32 endp


out_32	proc far pascal, io_port:word, io_data:dword

	mov	dx, io_port
	mov	eax, io_data
	out	dx, eax
	ret

out_32	endp


	END 

