/*
 * Copyright (c) 2006 Raritan, All Rights Reserved.
 * Author: Ralf Guenther ralf.guenther@raritan.com
 */

#ifndef IPMI_RARITANOEM_H
#define IPMI_RARITANOEM_H

#if HAVE_CONFIG_H
# include <config.h>
#endif
#include <ipmitool/ipmi.h>

#define IPMI_NETFN_RARITANOEM                       0x3c

// Firmware Upgrade
#define IPMI_RARITANOEM_GET_FIRMWARE_VERSION        0x20
#define IPMI_RARITANOEM_START_FIRMWARE_UPGRADE      0x21
#define IPMI_RARITANOEM_UPLOAD_FIRMWARE             0x22
#define IPMI_RARITANOEM_FLASH_FIRMWARE              0x23
#define IPMI_RARITANOEM_CANCEL_FIRMWARE_UPGRADE     0x24
#define IPMI_RARITANOEM_FINALIZE_FIRMWARE_UPGRADE   0x25

// Miscellaneous
#define IPMI_RARITANOEM_RESET_TO_FACTORY_DEFAULTS   0x40
#define IPMI_RARITANOEM_GET_SERIAL_NUMBER           0x41
#define IPMI_RARITANOEM_SET_SERIAL_NUMBER           0x42

// Remote Mass Storage
#define IPMI_RARITANOEM_GET_VMEDIA_STATUS           0x50
#define IPMI_RARITANOEM_CLOSE_VMEDIA_SESSION        0x51
#define IPMI_RARITANOEM_START_FLOPPY_IMG_UPLOAD     0x52
#define IPMI_RARITANOEM_UPLOAD_FLOPPY_IMG           0x53
#define IPMI_RARITANOEM_FINALIZE_FLOPPY_IMG_UPLOAD  0x54
#define IPMI_RARITANOEM_START_SMB_IMG_MOUNT         0x55
#define IPMI_RARITANOEM_SET_SMB_IMG_PARAM           0x56
#define IPMI_RARITANOEM_FINALIZE_SMB_IMG_MOUNT      0x57


int ipmi_raritanoem_main(struct ipmi_intf *, int, char **);

#endif /*IPMI_RARITANOEM_H*/

