#! /usr/bin/make

all: fixincludes $(SHARED_LIBS) $(EXTRAS)

.PHONY: fixincludes
fixincludes:
	mkdir -p include-fixed/linux/netfilter_ipv4
	mkdir -p include-fixed/linux/netfilter_ipv6
	sed -e 's,^extern __inline__,static __inline__,' \
		< $(KERNEL_DIR)/include/linux/netfilter_ipv4/ip_tables.h \
		> include-fixed/linux/netfilter_ipv4/ip_tables.h
	sed -e 's,^extern __inline__,static __inline__,' \
		< $(KERNEL_DIR)/include/linux/netfilter_ipv6/ip6_tables.h \
		> include-fixed/linux/netfilter_ipv6/ip6_tables.h

experimental: $(EXTRAS_EXP)

# Have to handle extensions which no longer exist.
clean: $(EXTRA_CLEANS)
	rm -f $(SHARED_LIBS) $(EXTRAS) $(EXTRAS_EXP) $(SHARED_LIBS:%.so=%_sh.o)
	rm -f extensions/initext.c extensions/initext6.c
	rm -rf include-fixed
	@find . -name '*.[ao]' -o -name '*.so' | xargs rm -f
	rm -f $(DESTDIR)/lib/libipq.a

install: all $(EXTRA_INSTALLS)
	$(INSTALL) -d $(DESTDIR)/lib
	$(INSTALL) -m 644 libipq/libipq.a $(DESTDIR)/lib/
	#@if [ -f /usr/local/bin/iptables -a "$(BINDIR)" = "/usr/local/sbin" ];\
	#then echo 'Erasing iptables from old location (now /usr/local/sbin).';\
	#rm -f /usr/local/bin/iptables;\
	#fi

install-experimental: $(EXTRA_INSTALLS_EXP)

TAGS:
	@rm -f $@
	find . -name '*.[ch]' | xargs etags -a

dep: $(DEPFILES) $(EXTRA_DEPENDS)
	@echo Dependencies will be generated on next make.
	rm -f $(DEPFILES) $(EXTRA_DEPENDS) .makefirst

$(SHARED_LIBS:%.so=%.d): %.d: %.c
	@-$(CC) -M -MG $(CFLAGS) $< | \
	    sed -e 's@^.*\.o:@$*.d $*_sh.o:@' > $@

$(SHARED_LIBS): %.so : %_sh.o
	$(LD) -shared -o $@ $<

%_sh.o : %.c
	$(CC) $(SH_CFLAGS) -o $@ -c $<

.makefirst:
	@echo Making dependencies: please wait...
	@touch .makefirst

# This is useful for when dependencies completely screwed
%.h::
	@echo Something wrong... deleting dependencies.
	@-rm -f $(DEPFILES) $(EXTRA_DEPENDS) .makefirst
	@[ -d $(KERNEL_DIR)/include/linux/netfilter_ipv4 ] || echo -e '\n\n    Please try `make KERNEL_DIR=path-to-correct-kernel'\'.'\n\n'
	@exit 1

-include $(DEPFILES) $(EXTRA_DEPENDS)
-include .makefirst
