/**********************
* constants           *
***********************/

/***************************************************************************
*
*   devices
*
***************************************************************************/

#define	DEVICE_EP1C3    0x01
#define	DEVICE_EP1C4    0x02
#define	DEVICE_EP1C6    0x03
#define	DEVICE_EP1C12   0x04
#define	DEVICE_EP1C20   0x05

/*******************************
* DS page 13-3                 *
  raw binary file size in bytes /
********************************/

#define	DEVICE_EP1C3_CONFSIZE     78422
#define	DEVICE_EP1C4_CONFSIZE    115564
#define	DEVICE_EP1C6_CONFSIZE    145902
#define	DEVICE_EP1C12_CONFSIZE   290816
#define	DEVICE_EP1C20_CONFSIZE   444951

/**********************************
 * 
 * from original byte blaster code
 *
 **********************************/

#define INIT_CYCLE			50		/* #clock cycle after configuration is done and before USER mode */
#define RECONF_COUNT_MAX		1		/* #auto-reconfiguration when error found */
#define	CHECK_EVERY_X_BYTE  		10240		/* check NSTATUS pin for error for every X bytes */
#define	CHECK_EVERY_X_BYTE2  		100		/* check NSTATUS pin for error for every X bytes */
							/* DO NOT put '0' */
#define CLOCK_X_CYCLE			100		/* clock another 'x' cycles during initialization (optional) */


/**********************
* function prototypes *
***********************/

void set_dclk(unsigned char val);    /* shared with ATMEL SCK */
void set_data0(unsigned char val);   /* shared with ATMEL MOSI */
void set_nconfig(unsigned char val); 
void set_conf_done(unsigned char val);
void set_nstatus(unsigned char val);
unsigned int get_conf_done(void);
unsigned int get_nstatus(void);

int  fpga_program(char * filename);
void ProcessFileInput( int fd_file );
void PrintError( int configuration_count);
