/******************************************************************/
/*                                                                */
/* Module:       jb_device_info.h                                 */
/*                                                                */
/* Descriptions: Contain information of Altera devices.           */
/*                                                                */
/* Revisions:    .0 02/22/02                                      */
/*		 .2 10/23/02					  */
/*		 Stratix JTAG ID-Code added			  */
/*		 .3 1/24/03					  */
/*		 Cyclone JTAG ID-Code added			  */
/*		 .4 6/3/03					  */
/*		 Stratix GX JTAG ID-Code added			  */
/*		 1C4 JTAG ID-Code added				  */
/*		 .5 6/1/04					  */
/*		 Stratix II EP2S60 JTAG ID-Code added		  */
/*		 .6 1/28/05					  */
/*		 Stratix II JTAG ID-Code added			  */
/*               Cyclone II EP2C35 JTAG ID-Code added		  */
/*		 .7 11/15/05					  */
/*               Cyclone II JTAG ID-Code added			  */
/******************************************************************/

#ifndef JB_DEVICE_INFO_H
#define JB_DEVICE_INFO_H


#define MAX_DEV_FAMILY 13
#define MAX_DEV_LIST   190

int start_of_device_family[MAX_DEV_FAMILY] = {
	0,   /* ACEX      */
	14,  /* APEX II   */
	24,  /* APEX 20K  */
	35,  /* APEX 20KC */
	47,  /* APEX 20KE */
	83,  /* FLEX 10KE */
	112, /* MERCURY   */
	114, /* STRATIX   */
	143, /* CYCLONE   */	//AKL4A22 Change from 145 to 143
	155, /* STRATIX GX */
	158, /* STRATIX II */
	174, /* CYCLONE II */
	189  /*	MAX II     */
};

int MAX_JTAG_INIT_CLOCK[MAX_DEV_FAMILY] = {
	30,   /* ACEX      */
	175,  /* APEX II   */
	175,  /* APEX 20K  */
	175,  /* APEX 20KC */
	175,  /* APEX 20KE */
	30,   /* FLEX 10KE */
	175,  /* MERCURY   */
	175,  /* STRATIX   */
	175,  /* CYCLONE   */
	175,  /* STRATIX GX */
	300,  /* STRATIX II */
	300,  /* CYCLONE II */
	175,  /* MAX II     */
};

char family_name[MAX_DEV_FAMILY][12] = {
	{"ACEX 1K"},
	{"APEX II"},
	{"APEX 20K"},
	{"APEX 20KC"},
	{"APEX 20KE"},
	{"FLEX 10KE"},
	{"MERCURY"},
	{"STRATIX"},
	{"CYCLONE"},
	{"STRATIX GX"},
	{"STRATIX II"},
	{"CYCLONE II"},
	{"MAX II"}
};

char device_name[MAX_DEV_LIST][20] = {
/* ACEX 1K */
	{"EP1K10F256"},/* start of ACEX 0 */
	{"EP1K10Q208"},//	1
	{"EP1K10T100"},//	2
	{"EP1K10T144"},//	3
	{"EP1K30F256"},//	4
	{"EP1K30Q208"},//	5
	{"EP1K30T144"},//	6
	{"EP1K50F256"},//	7
	{"EP1K50F484"},//	8
	{"EP1K50Q208"},//	9
	{"EP1K50T144"},//	10
	{"EP1K100F256"},//	11
	{"EP1K100F484"},//	12
	{"EP1K100Q208"},//	13
/* APEX II */
	{"EP2A15B724"},/* start of APEX II 14 */
	{"EP2A15F672"},//	15
	{"EP2A25B724"},//	16
	{"EP2A25F672"},//	17
	{"EP2A25F1020"},//	18
	{"EP2A40B724"},//	19
	{"EP2A40F672"},//	20
	{"EP2A40F1020"},//	21
	{"EP2A70B724"},//	22
	{"EP2A70F1508"},//	23
/* APEX 20K */
	{"EP20K100B356"},/* start of APEX 20K 24 */
	{"EP20K100F324"},//	25
	{"EP20K100Q208"},//	26
	{"EP20K100Q240"},//	27
	{"EP20K100T144"},//	28
	{"EP20K200B356"},//	29
	{"EP20K200F484"},//	30
	{"EP20K200R208"},//	31
	{"EP20K200R240"},//	32
	{"EP20K400B652"},//	33
	{"EP20K400F672"},//	34
/* APEX 20KC */
	{"EP20K200CB356"},/* start of APEX 20KC 35 */
	{"EP20K200CF484"},//	36
	{"EP20K200CQ208"},//	37
	{"EP20K200CQ240"},//	38
	{"EP20K400CB652"},//	39
	{"EP20K400CF672"},//	40
	{"EP20K600CB652"},//	41
	{"EP20K600CF672"},//	42
	{"EP20K600CF33"},//		43
	{"EP20K1000CB652"},//	44
	{"EP20K1000CF672"},//	45
	{"EP20K1000CF33"},//	46
/* APEX 20KE */
	{"EP20K30ET144"},/* start of APEX 20KE 47 */
	{"EP20K60EB356"},//	48
	{"EP20K60EF144"},//	49
	{"EP20K60EF324"},//	50
	{"EP20K60EQ208"},//	51
	{"EP20K60ET144"},//	52
	{"EP20K100EB356"},//	53
	{"EP20K100EF144"},//	54
	{"EP20K100EF324"},//	55
	{"EP20K100EQ208"},//	56
	{"EP20K100EQ240"},//	57
	{"EP20K100ET144"},//	58
	{"EP20K160EB356"},//	59
	{"EP20K160EF484"},//	60
	{"EP20K160EQ208"},//	61
	{"EP20K160EQ240"},//	62
	{"EP20K160ET144"},//	63
	{"EP20K200EB356"},//	64
	{"EP20K200EB652"},//	65
	{"EP20K200EF484"},//	66
	{"EP20K200EF672"},//	67
	{"EP20K200EQ208"},//	68
	{"EP20K200EQ240"},//	69
	{"EP20K300EB652"},//	70
	{"EP20K300EF672"},//	71
	{"EP20K300EQ240"},//	72
	{"EP20K400EB652"},//	73
	{"EP20K400EF672"},//	74
	{"EP20K600EB652"},//	75
	{"EP20K600EF672"},//	76
	{"EP20K600EF33"},//		77
	{"EP20K1000EB652"},//	78
	{"EP20K1000EF672"},//	79
	{"EP20K1000EF33"},//	80
	{"EP20K1500EB652"},//	81
	{"EP20K1500EF33"},//	82
/* FLEX 10KE */
	{"EPF10K30EF256"},/* start of FLEX 10KE 83 */
	{"EPF10K30EF484"},//	84
	{"EPF10K30EQ208"},//	85
	{"EPF10K30ET144"},//	86
	{"EPF10K50EF256"},//	87
	{"EPF10K50EQ240"},//	88
	{"EPF10K50ET144"},//	89
	{"EPF10K50SB356"},//	90
	{"EPF10K50SF256"},//	91
	{"EPF10K50SF484"},//	92
	{"EPF10K50SQ208"},//	93
	{"EPF10K50SQ240"},//	94
	{"EPF10K50ST144"},//	95
	{"EPF10K100EB356"},//	96
	{"EPF10K100EF256"},//	97
	{"EPF10K100EF484"},//	98
	{"EPF10K100EQ208"},//	99
	{"EPF10K100EQ240"},//	100
	{"EPF10K130EB356"},//	101
	{"EPF10K130EB600"},//	102
	{"EPF10K130EF484"},//	103
	{"EPF10K130EF672"},//	104
	{"EPF10K130EQ240"},//	105
	{"EPF10K200EB600"},//	106
	{"EPF10K200SB356"},//	107
	{"EPF10K200SB600"},//	108
	{"EPF10K200SF484"},//	109
	{"EPF10K200SF672"},//	110
	{"EPF10K200SR240"},//	111
/* MERCURY */
	{"EP1M120F484"},/* start of MERCURY 112 */
	{"EP1M350F780"},//		113
/* STRATIX */
	{"EP1S10B672"},/* start of STRATIX 114 */
	{"EP1S10F484"},//		115
	{"EP1S10F672"},//		116
	{"EP1S10F780"},//		117
	{"EP1S10B672ES"},//		118
	{"EP1S10F484ES"},//		119
	{"EP1S10F672ES"},//		120
	{"EP1S10F780ES"},//		121
	{"EP1S20B672"},//		122
	{"EP1S20F484"},//		123
	{"EP1S20F672"},//		124
	{"EP1S20F780"},//		125
	{"EP1S25B672"},//		126
	{"EP1S25F672"},//		127
	{"EP1S25F780"},//		128
	{"EP1S25F1020"},//		129
	{"EP1S30B956"},//		130
	{"EP1S30F780"},//		131
	{"EP1S30F1020"},//		132
	{"EP1S40B956"},//		133
	{"EP1S40F780"},//		134
	{"EP1S40F1020"},//		135
	{"EP1S40F1508"},//		136
	{"EP1S60B956"},//		137
	{"EP1S60F1020"},//		138
	{"EP1S60F1508"},//		139
	{"EP1S80B956"},//		140
	{"EP1S80F1020"},//		141
	{"EP1S80F1508"},//		142
/* CYCLONE */
	{"EP1C20F324"},/* start of CYCLONE 143 */
	{"EP1C20F400"},//		144
	{"EP1C12F256"},//		145
	{"EP1C12F324"},//		146
	{"EP1C12Q240"},//		147
	{"EP1C6F256"},//		148
	{"EP1C6Q240"},//		149
	{"EP1C6T144"},//		150
	{"EP1C4F400"},//		151
	{"EP1C4F324"},//		152
	{"EP1C3T100"},//		153
	{"EP1C3T144"},//		154
/* STRATIX GX */
	{"EP1SGX40"},/* start of STRATIX GX 155 */
	{"EP1SGX25"},//		156
	{"EP1SGX10"},//		157
/* STRATIX II ES*/
	{"EP2S60F484ES"},///* start of STRATIX II ES 158 */	
	{"EP2S60F672ES"},//		159
	{"EP2S60F1020ES"},//	160
/* STRATIX II */
	{"EP2S15F484"},///* start of STRATIX II 161 */
	{"EP2S15F672"},//		162
	{"EP2S30F484"},//		163
	{"EP2S30F672"},//		164
	{"EP2S60F484"},//		165
	{"EP2S60F672"},//		166
	{"EP2S60F1020"},//		167
	{"EP2S90F1020"},//		168
	{"EP2S90F1508"},//		169
	{"EP2S130F1020"},//		170
	{"EP2S130F1508"},//		171
	{"EP2S180F1020"},//		172
	{"EP2S180F1508"},//		173
/* CYCLONE II */
	{"EP2C35F484"},///* start of CYCLONE II 174 */
	{"EP2C35F672"},//		175
	{"EP2C5T144"},//		176
	{"EP2C5Q208"},//		177	
	{"EP2C5F256"},//		178
	{"EP2C8T144"},//		179	
	{"EP2C8Q208"},//		180
	{"EP2C8F256"},//		181	
	{"EP2C20Q240"},//		182
	{"EP2C20F256"},//		183	
	{"EP2C20F484"},//		184
	{"EP2C50F484"},//		185	
	{"EP2C50F672"},//		186
	{"EP2C70F672"},//		187	
	{"EP2C70F896"}, //		188	
/* MAX II */
        {"EPM240T100"}  //              189	
	};

unsigned int device_info[MAX_DEV_LIST][4] = {
/* Device,        Idcode,   Max      Conf_done Instruction */
/*                          JTAG     JTAG      Length      */
/*                          Sequence,Sequence,             */ 
/* ACEX 1K */
	/* 10F256     */ {0x110100DD, 146, 146, 10},	//0
	/* 10Q208     */ {0x110100DD, 146, 146, 10},	//1
	/* 10T100     */ {0x110100DD, 146, 146, 10},	//2
	/* 10T144     */ {0x110100DD, 146, 146, 10},	//3
	/* 30F256     */ {0x110300DD, 230, 230, 10},	//4
	/* 30Q208     */ {0x110300DD, 230, 230, 10},	//5
	/* 30T144     */ {0x110300DD, 230, 230, 10},	//6
	/* 50F256     */ {0x110500DD, 266, 266, 10},	//7
	/* 50F484     */ {0x110500DD, 266, 266, 10},	//8
	/* 50Q208     */ {0x110500DD, 266, 266, 10},	//9
	/* 50T144     */ {0x110500DD, 266, 266, 10},	//10
	/* 100F256    */ {0x201000DD, 350, 350, 10},	//11
	/* 100F484    */ {0x201000DD, 350, 350, 10},	//12
	/* 100Q208    */ {0x201000DD, 350, 350, 10},	//13
/* APEX II */
	/* 15B724     */ {0xC4000DD, 508, 191, 10},		//14
	/* 15F672     */ {0xC4000DD, 508, 191, 10},		//15
	/* 25B724     */ {0xC6000DD, 628, 251, 10},		//16
	/* 25F672     */ {0xC6000DD, 628, 251, 10},		//17
	/* 25F1020    */ {0xC6000DD, 628, 251, 10},		//18
	/* 40B724     */ {0xD0000DD, 776, 293, 10},		//19
	/* 40F672     */ {0xD0000DD, 776, 293, 10},		//20
	/* 40F1020    */ {0xD0000DD, 776, 293, 10},		//21
	/* 70B724     */ {0xE0000DD, 1076, 443, 10},	//22
	/* 70F1508    */ {0XE0000DD, 1076, 443, 10},	//23
/* APEX 20K */
	/* 100B356    */ {0x04160DD, 262, 98, 10},		//24
	/* 100F324    */ {0x04160DD, 262, 98, 10},		//25
	/* 100Q208    */ {0x04160DD, 262, 98, 10},		//26
	/* 100Q240    */ {0x04160DD, 262, 98, 10},		//27
	/* 100T144    */ {0x04160DD, 262, 98, 10},		//28
	/* 200B356    */ {0x08320DD, 392, 163, 10},		//29
	/* 200F484    */ {0x08320DD, 392, 163, 10},		//30
	/* 200R208    */ {0x08320DD, 392, 163, 10},		//31
	/* 200R240    */ {0x08320DD, 392, 163, 10},		//32
	/* 400B652    */ {0x16640DD, 512, 193, 10},		//33
	/* 400F672    */ {0x16640DD, 512, 193, 10},		//34
/* APEX 20KC */
	/* 200CB356   */ {0x82000DD, 388, 159, 10},		//35
	/* 200CF484   */ {0x82000DD, 388, 159, 10},		//36
	/* 200CQ208   */ {0x82000DD, 388, 159, 10},		//37
	/* 200CQ240   */ {0x82000DD, 388, 159, 10},		//38
	/* 400CB652   */ {0x84000DD, 502, 189, 10},		//39
	/* 400CF672   */ {0x84000DD, 502, 189, 10},		//40
	/* 600CB652   */ {0x84000DD, 602, 239, 10},		//41
	/* 600CF672   */ {0x84000DD, 602, 239, 10},		//42
	/* 600CF33    */ {0x84000DD, 602, 239, 10},		//43
	/* 1000CB652  */ {0x90000DD, 730, 271, 10},		//44
	/* 1000CF672  */ {0x90000DD, 730, 271, 10},		//45
	/* 1000CF33   */ {0x90000DD, 730, 271, 10},		//46
/* APEX 20KE */
	/* 30ET144    */ {0x80300DD, 140, 47, 10},		//47
	/* 60EB356    */ {0x80600DD, 208, 69, 10},		//48
	/* 60EF144    */ {0x80600DD, 208, 69, 10},		//49
	/* 60EF324    */ {0x80600DD, 208, 69, 10},		//50
	/* 60EQ208    */ {0x80600DD, 208, 69, 10},		//51
	/* 60ET144    */ {0x80600DD, 208, 69, 10},		//52
	/* 100EB356   */ {0x81000DD, 258, 94, 10},		//53
	/* 100EF144   */ {0x81000DD, 258, 94, 10},		//54
	/* 100EF324   */ {0x81000DD, 258, 94, 10},		//55
	/* 100EQ208   */ {0x81000DD, 258, 94, 10},		//56
	/* 100EQ240   */ {0x81000DD, 258, 94, 10},		//57
	/* 100ET144   */ {0x81000DD, 258, 94, 10},		//58
	/* 160EB356   */ {0x81600DD, 328, 129, 10},		//59
	/* 160EF484   */ {0x81600DD, 328, 129, 10},		//60
	/* 160EQ208   */ {0x81600DD, 328, 129, 10},		//61
	/* 160EQ240   */ {0x81600DD, 328, 129, 10},		//62
	/* 160ET144   */ {0x81600DD, 328, 129, 10},		//63
	/* 200EB356   */ {0x82000DD, 388, 159, 10},		//64
	/* 200EB652   */ {0x82000DD, 388, 159, 10},		//65
	/* 200EF484   */ {0x82000DD, 388, 159, 10},		//66
	/* 200EF672   */ {0x82000DD, 388, 159, 10},		//67
	/* 200EQ208   */ {0x82000DD, 388, 159, 10},		//68
	/* 200EQ240   */ {0x82000DD, 388, 159, 10},		//69
	/* 300EB652   */ {0x83000DD, 422, 149, 10},		//70
	/* 300EB672   */ {0x83000DD, 422, 149, 10},		//71
	/* 300EQ240   */ {0x83000DD, 422, 149, 10},		//72
	/* 400EB652   */ {0x84000DD, 502, 189, 10},		//73
	/* 400EF672   */ {0x84000DD, 502, 189, 10},		//74
	/* 600EB652   */ {0x84000DD, 602, 239, 10},		//75
	/* 600EF672   */ {0x84000DD, 602, 239, 10},		//76
	/* 600EF33    */ {0x84000DD, 602, 239, 10},		//77
	/* 1000EB652  */ {0x90000DD, 730, 271, 10},		//78
	/* 1000EF672  */ {0x90000DD, 730, 271, 10},		//79
	/* 1000EF33   */ {0x90000DD, 730, 271, 10},		//80
	/* 1500EB652  */ {0x95000DD, 834, 323, 10},		//81
	/* 1500EF33   */ {0x95000DD, 834, 323, 10},		//82
/* FLEX 10KE */
	/* 30EF256    */ {0x110300DD, 230, 230, 10},	//83
	/* 30EF484    */ {0x110300DD, 230, 230, 10},	//84
	/* 30EQ208    */ {0x110300DD, 230, 230, 10},	//85
	/* 30ET144    */ {0x110300DD, 230, 230, 10},	//86
	/* 50EF256    */ {0x110500DD, 266, 266, 10},	//87
	/* 50EQ240    */ {0x110500DD, 266, 266, 10},	//88
	/* 50ET144    */ {0x110500DD, 266, 266, 10},	//89
	/* 50SB356    */ {0x110500DD, 266, 266, 10},	//90
	/* 50SF256    */ {0x110500DD, 266, 266, 10},	//91
	/* 50SF484    */ {0x110500DD, 266, 266, 10},	//92
	/* 50SQ208    */ {0x110500DD, 266, 266, 10},	//93
	/* 50SQ240    */ {0x110500DD, 266, 266, 10},	//94
	/* 50ST144    */ {0x110500DD, 266, 266, 10},	//95
	/* 100EB356   */ {0x201000DD, 350, 350, 10},	//96
	/* 100EF256   */ {0x201000DD, 350, 350, 10},	//97
	/* 100EF484   */ {0x201000DD, 350, 350, 10},	//98
	/* 100EQ208   */ {0x201000DD, 350, 350, 10},	//99
	/* 100EQ240   */ {0x201000DD, 350, 350, 10},	//100
	/* 130EB356   */ {0x101300DD, 436, 436, 10},	//101
	/* 130EB600   */ {0x101300DD, 436, 436, 10},	//102
	/* 130EF484   */ {0x101300DD, 436, 436, 10},	//103
	/* 130EF672   */ {0x101300DD, 436, 436, 10},	//104
	/* 130EQ240   */ {0x101300DD, 436, 436, 10},	//105
	/* 200EB600   */ {0x102000DD, 482, 482, 10},	//106
	/* 200SB356   */ {0x102000DD, 482, 482, 10},	//107
	/* 200SB600   */ {0x102000DD, 482, 482, 10},	//108
	/* 200SF484   */ {0x102000DD, 482, 482, 10},	//109
	/* 200SF672   */ {0x102000DD, 482, 482, 10},	//110
	/* 200SR240   */ {0x102000DD, 482, 482, 10},	//111
/* MERCURY */
	/* 120F484    */ {0x30000DD, 375, 5, 10},		//112
	/* 350F780    */ {0x30010DD, 565, 7, 10},		//113
/* STRATIX */
	/* 10B672     */ {0x20010DD, 439, 391, 10},		//114
	/* 10F484     */ {0x20010DD, 439, 391, 10},		//115
	/* 10F672     */ {0x20010DD, 439, 391, 10},		//116
	/* 10F780     */ {0x20010DD, 439, 391, 10},		//117
	/* 10B672ES   */ {0x20030DD, 439, 391, 10},		//118
	/* 10F484ES   */ {0x20030DD, 439, 391, 10},		//119
	/* 10F672ES   */ {0x20030DD, 439, 391, 10},		//120
	/* 10F780ES   */ {0x20030DD, 439, 391, 10},		//121
	/* 20B672     */ {0x20020DD, 599, 533, 10},		//122
	/* 20F484     */ {0x20020DD, 599, 533, 10},		//123
	/* 20F672     */ {0x20020DD, 599, 533, 10},		//124
	/* 20F780     */ {0x20020DD, 599, 533, 10},		//125
	/* 25B672     */ {0x20030DD, 719, 635, 10},		//126
	/* 25F672     */ {0x20030DD, 719, 635, 10},		//127
	/* 25F780     */ {0x20030DD, 719, 635, 10},		//128
	/* 25F1020    */ {0x20030DD, 719, 635, 10},		//129
	/* 30B956     */ {0x20040DD, 751, 667, 10},		//130
	/* 30F780     */ {0x20040DD, 751, 667, 10},		//131
	/* 30F1020    */ {0x20040DD, 751, 667, 10},		//132
	/* 40B956     */ {0x20050DD, 843, 741, 10},		//133
	/* 40F780	  */ {0x20050DD, 843, 741, 10},		//134
	/* 40F1020    */ {0x20050DD, 843, 741, 10},		//135
	/* 40F1508    */ {0x20050DD, 843, 741, 10},		//136
	/* 60B956     */ {0x20060DD, 1043, 923, 10},	//137
	/* 60F1020    */ {0x20060DD, 1043, 923, 10},	//138
	/* 60F1508    */ {0x20060DD, 1043, 923, 10},	//139
	/* 80B956     */ {0x20070DD, 1259, 1121, 10},	//140
	/* 80F1020    */ {0x20070DD, 1259, 1121, 10},	//141
	/* 80F1508    */ {0x20070DD, 1259, 1121, 10},	//142
/* CYCLONE */	
	/* 20F324	  */ {0x20840DD, 310, 197, 10},		//143
	/* 20F400	  */ {0x20840DD, 310, 197, 10},		//144
	/* 12F256	  */ {0x20830DD, 258, 163, 10},		//145
	/* 12F324	  */ {0x20830DD, 258, 163, 10},		//146
	/* 12Q240	  */ {0x20830DD, 258, 163, 10},		//147
	/* 6F256	  */ {0x20820DD, 194, 121, 10},		//148
	/* 6Q240	  */ {0x20820DD, 194, 121, 10},		//149
	/* 6T144	  */ {0x20820DD, 194, 121, 10},		//150
	/* 4F400	  */ {0x20850DD, 310, 198, 10},		//151
	/* 4F324	  */ {0x20850DD, 310, 198, 10},		//152
	/* 3T100	  */ {0x20810DD, 113, 69, 10},		//153
	/* 3T144	  */ {0x20810DD, 113, 69, 10},		//154
/* STRATIX GX */
	/* 1SGX40     */ {0x20450DD,647,545,10},		//155
	/* 1SGX25     */ {0x20430DD,555,471,10},		//156
	/* 1SGX10	  */ {0x20410DD,343,295,10},		//157
/* STRATIX II ES*/
	/* 2S60F484ES */ {0x20930DD,732,731,10},		//158
	/* 2S60F672ES */ {0x20930DD,732,731,10},		//159
	/* 2S60F1020ES*/ {0x20930DD,732,731,10},		//160
/* STRATIX II */
	/* 2S15F484 */   {0x20910DD,380,379,10},		//161
	/* 2S15F672 */   {0x20910DD,380,379,10},		//162
	/* 2S30F484 */   {0x20920DD,564,563,10},		//163
	/* 2S30F672 */   {0x20920DD,564,563,10},		//164
	/* 2S60F484 */   {0x120930DD,732,731,10},		//165
	/* 2S60F672 */   {0x120930DD,732,731,10},		//166
	/* 2S60F1020*/   {0x120930DD,732,731,10},		//167
	/* 2S90F1020*/   {0x20940DD,916,915,10},		//168
	/* 2S90F1508*/   {0x20940DD,916,915,10},		//169
	/* 2S130F1020*/  {0x20950DD,1140,1139,10},		//170
	/* 2S130F1508*/  {0x20950DD,1140,1139,10},		//171
	/* 2S180F1020*/  {0x20960DD,1316,1315,10},		//172
	/* 2S180F1508*/  {0x20960DD,1316,1315,10},		//173
/* CYCLONE II */
	/* 2C35F484 */   {0x20B40DD,483,296,10},		//174
	/* 2C35F672 */   {0x20B40DD,483,296,10}, 		//175
	/* 2C5T144	*/	 {0x20B10DD,166,97,10},			//176
	/* 2C5Q208	*/	 {0x20B10DD,166,97,10},			//177	
	/* 2C5F256	*/	 {0x20B10DD,166,97,10},			//178	
	/* 2C8T144	*/	 {0x20B20DD,199,119,10},		//179
	/* 2C8Q208	*/	 {0x20B20DD,199,119,10},		//180	
	/* 2C8F256	*/	 {0x20B20DD,199,119,10},		//181		
	/* 2C20Q240	*/	 {0x20B30DD,323,193,10},		//182
	/* 2C20F256	*/	 {0x20B30DD,323,193,10},		//183
	/* 2C20F484	*/	 {0x20B30DD,323,193,10},		//184
	/* 2C50F484	*/	 {0x20B50DD,458,280,10},		//185	
	/* 2C50F672	*/	 {0x20B50DD,458,280,10},		//186
	/* 2C70F672	*/	 {0x20B60DD,630,391,10},		//187
	/* 2C70F896	*/	 {0x20B60DD,630,391,10},		//188
/* MAX II */
	/* 240T100      */       {0x20A10DD,80,121,10}                  //189
};

#endif

















