/******************************************************************/
/*                                                                */
/* Module:       jb_jtag.h                                        */
/*                                                                */
/* Descriptions: Manages JTAG State Machine (JSM), loading of     */
/*               JTAG instructions and reading of data from TDO.  */
/*                                                                */
/* Revisions:    1.0 02/22/02                                     */
/*                                                                */
/******************************************************************/

#ifndef JB_JTAG_H
#define JB_JTAG_H


int  AdvanceJSM(int);
int  ReadTDO(int bits,int data,int inst);
void PrintJS(void);
void SetupChain(int dev_count,int dev_seq,int* ji_info,int action);

int  LoadJI(int inst,int dev_count,int* ji_info);
int  Ji_Extest(int device,int* ji_info);
int  Ji_Program(int device,int* ji_info);
int  Ji_Startup(int device,int* ji_info);
int  Ji_Checkstatus(int device,int* ji_info);
int  Ji_Sample(int device,int* ji_info);
int  Ji_Idcode(int device,int* ji_info);
int  Ji_Usercode(int device,int* ji_info);
int  Ji_Intest(int device,int* ji_info);
int  Ji_Regscan(int device,int* ji_info);
int  Ji_User0(int device,int* ji_info);
int  Ji_User1(int device,int* ji_info);
int  Ji_Bypass(int device,int* ji_info);

void Js_Reset(void);
void Js_Runidle(void);
int  Js_Shiftdr(void);
int  Js_Updatedr(void);


#endif
