#ifndef _COMMON_DEBUG_H
#define _COMMON_DEBUG_H

/* debugging defines for the kernel modules */

#define D_SILENT			0
#define D_ALWAYS			1
#define D_ERROR				2
#define D_NOTICE			3
#define D_VERBOSE			4
#define D_BLABLA			5

#ifndef DEBUGLEVEL
# define DEBUGLEVEL D_ERROR
#endif
#define D(x, fmt, args...)		{ if (x <= DEBUGLEVEL) { printk("%s: ", DRV_NAME); printk(fmt, ##args); } }

#endif /* _COMMON_DEBUG_H */
