/**
 * fml_esb2.h
 *
 * FML TCP Pass Through sideband protocol of
 * Intel ESB2 (Southbridge)
 *
 * (c) 2005 Peppercon AG, 2005/07/21, Ralf Guenther <rgue@peppecon.de>
 */

#ifndef __FML_OPHIR_H__
#define __FML_OPHIR_H__

#define ESB2_OP_REQ_NONE            0x00
#define ESB2_OP_REQ_READ            0x40
#define ESB2_OP_REQ_STATUS          0x80

#define ESB2_OP_LONG_TRANS          0x10

#define ESB2_OP_MASK                0x0f
#define ESB2_OP_STATUS              0x00
#define ESB2_OP_STP		    0x01
#define ESB2_OP_FNI		    0x02
                                 /* 0x03 - reserved */
#define ESB2_OP_IPMI                0x04
#define ESB2_OP_TPT                 0x05
#define ESB2_OP_RESET_FML           0x0d
#define ESB2_OP_CLEAR_FML_ERR       0x0e

#define ESB2_LEN_LONG_TRANS         0xfc

#define ESB2_STATUS_MASK            0xf0
#define ESB2_STATUS_OUT_DATA_AVAIL  0x80
#define ESB2_STATUS_IN_BUF_FULL     0x40

#define ESB2_ERR_MASK               0x0f
#define ESB2_ERR_NONE               0x00
#define ESB2_ERR_IN_DATA_OVERRUN    0x01
#define ESB2_ERR_READ_EMPTY_BUF     0x02
#define ESB2_ERR_FML_RESET          0x03
#define ESB2_ERR_FML_BUS_FAILURE    0x04

struct fmlcore_private;

extern int esb2_tpt_blk_lost; // number of lost incoming packets

#define MESB2_MAX_BLK_LEN 1400

int esb2_fml_tpt_read_req(struct fmlcore_private *fml, int max_len);
int esb2_fml_fni_read_req(struct fmlcore_private *fml, int max_len);
int esb2_fml_stat_req(struct fmlcore_private *fml);
int esb2_fml_reset(struct fmlcore_private *fml);
int esb2_fml_clr_err(struct fmlcore_private *fml);
int esb2_fml_write(struct fmlcore_private *fml, const unsigned char *data, int len);

int esb2_tpt_get_status(struct fmlcore_private *fml,
                        unsigned char chan,
                        unsigned char *pstat,
                        unsigned char *remote_ip);
int esb2_fni_get_status(struct fmlcore_private *fml,
                        unsigned char chan,
                        unsigned char *pstat,
                        unsigned char *remote_ip);
int esb2_tpt_send(struct fmlcore_private *fml,
                  unsigned char chan,
                  const unsigned char *data,
                  int len);
int esb2_fni_send(struct fmlcore_private *fml,
                  unsigned char chan,
		  unsigned char mode,
		  unsigned char seq,
                  const unsigned char *data,
                  int len);
int esb2_tpt_recv(struct fmlcore_private *fml,
                  unsigned char *pchan,
                  unsigned char *data,
                  int busize);
int esb2_recv(struct fmlcore_private *fml,
                  unsigned char *pchan,
		  unsigned char *op,
                  unsigned char *data,
                  int bufsize);

#endif /* !__FML_OPHIR_H__ */
