#ifndef __FML_I825XX_H__
#define __FML_I825XX_H__

#include <linux/delay.h>

#include "tco_core.h"

/* TCO commands */
#define I825XX_CMD_RECV_ANY      ((uint8_t)0x00)
#define I825XX_CMD_XMIT          ((uint8_t)0x04)
#define I825XX_CMD_XMIT_NOCRC    ((uint8_t)0x14)
#define I825XX_CMD_RECV_EN       ((uint8_t)0x0a)
#define I825XX_CMD_REQ_STATUS    ((uint8_t)0x1d)
#define I825XX_CMD_FORCE_TCO     ((uint8_t)0x0f)

/* read opcodes */
#define I825XX_RECV_PACKET       ((uint8_t)0x10)
#define I825XX_RECV_STATUS       ((uint8_t)0x1d)

/* Receive Enable flags */
#define I825XX_RCV_EN            ((uint8_t)1 << 0)
#define I825XX_RCV_ALL           ((uint8_t)1 << 1)
#define I825XX_EN_STA            ((uint8_t)1 << 2)

/* Read Status flags */
#define I825XX_CMD_ABORTED       ((uint8_t)1 << 6)
#define I825XX_LINK_STATE        ((uint8_t)1 << 5)
#define I825XX_RU_READY          ((uint8_t)1 << 4)
#define I825XX_INIT              ((uint8_t)1 << 3)
#define I825XX_POWER_STATE_MASK  ((uint8_t)3 << 0)

/* Packet sequence flags */
#define I825XX_CMD_MASK          ((uint8_t)0x3f)
#define I825XX_SEQ_MASK          ((uint8_t)0xc0)
#define I825XX_SEQ_SINGLE        ((uint8_t)0xc0)
#define I825XX_SEQ_FIRST         ((uint8_t)0x80)
#define I825XX_SEQ_LAST          ((uint8_t)0x40)
#define I825XX_SEQ_MIDDLE        ((uint8_t)0x00)

#define I825XX_MAX_DATA_SIZE 32

/*
 * receive packet layout
 */

typedef struct tco_recv_pkt_s {
    uint8_t op_code;
    uint8_t data[I825XX_MAX_DATA_SIZE];
} __attribute__ ((packed)) tco_recv_pkt_t;

int i825xx_detect(tco_t *tco);
int i825xx_xmit_packet(tco_t *tco, uint8_t seq, uint8_t len, uint8_t *data);
int i825xx_recv_enable(tco_t *tco, uint8_t ctrl);
int i825xx_request_status(tco_t *tco);
int i825xx_force_tco(tco_t *tco, uint8_t mode);
int i825xx_recv(tco_t *tco, uint8_t *count, tco_recv_pkt_t *recv_pkt);
int i825xx_read_status(tco_t *tco, uint8_t *status);

#endif /* !__FML_OPHIR_H__ */
