#ifndef __FML_MOD_H__
#define __FML_MOD_H__

#include <linux/list.h>
#include <linux/netdevice.h>
#include "fml.h"
#include "tco_core.h"

#define SUCCESS 0

// init args
#define FIRST_INIT  ((void*)0)
#define RE_INIT     ((void*)1)

#if 0
#include <pp_gpio.h>
#define trig_init() { if (pp_gpio_init(PP_GPIO_DEV_FARADAY) < 0) ERR("GPIO dev not open"); }
#define trig_fire() { pp_gpio_set(PP_GPIO_DEV_FARADAY, 0, 1 << 22, 0); udelay(1); pp_gpio_set(PP_GPIO_DEV_FARADAY, 0, 0, 1 << 22); }
#else
#define trig_init()
#define trig_fire()
#endif

/* ------------------------------------------------------------------------- *
 * realtime job types
 * ------------------------------------------------------------------------- */

typedef int (*job_func_t)(void*);

typedef struct job_s {
    struct list_head    anchor;
    job_func_t          func;
    void                *ctx;
    int                 ret;
    struct semaphore    *done;
} job_t;

/* ------------------------------------------------------------------------- *
 * private data
 * ------------------------------------------------------------------------- */

typedef struct fml_mod_priv_s {
    atomic_t                refcnt;

    struct sk_buff          *recv_skb;
    struct sk_buff          *send_skb;
    int                     send_offs;
    struct net_device_stats stats;
    int                     is_init;
    int                     mac_set;

    tco_t                   *tco;

    // job queue
    struct list_head        job_queue;
    spinlock_t              job_queue_lock;
    wait_queue_head_t       job_queue_wait;

    // async jobs
    job_t                   recv_job;
    job_t                   send_job;
    job_t                   reinit_job;

    fml_ioctl_hk_t          hk;
} fml_mod_priv_t;

extern struct net_device fml_mod_dev;
extern fml_mod_priv_t fml_mod_priv;

void dump(unsigned char* buf, int size);
void add_job(fml_mod_priv_t *priv, job_t *job);

#endif

