/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  CIM Protocol Diagnostic Utilities header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _CIM_H_
#define _CIM_H_

#include "fpd_ioctl.h"

#define MAX_PROTOCOL_BUFFER_SIZE               (512)
#define MAX_HOST_BUFFER_SIZE                   (64 * 1024)
#define DEFAULT_POLL_TIMEOUT                   (60 * 1000)
#define MAX_TRIES                              (10000000)

/* CIM types */
#define CIM_UNKNOWN                                    0
#define PCIM                                           1
#define DCIM                                           2
#define VMCIM                                          3

typedef struct {
    int target_port;
    int protocol;
    int tx_parity;
    int rx_parity;
} line_connection_t;

typedef struct {
    int link_if;
    int rx_cim;
    int rx_priority;
    int rx_host[FPD_HOST_CNT];
    int echo_rsp;
    unsigned int error;
} rx_notify_t;

typedef enum {
    RECEIVE = 0,
    SEND
} direction_t;

/* global variables */
extern int  debug_on;
extern unsigned char *protocol_buffer;
extern int  max_link_if;
extern int  max_line_cnt;
extern int  max_host_chan;
extern char bgnd_link_if_present;

/* function declarations */
extern int  cim_init( int fd );
extern int  cim_cleanup( void );
extern int  cim_get_current_link_if( void );
extern int  cim_get_line_connection_info( int link_id, line_connection_t **pconn );
extern int  cim_set_line_connection_info( int link_id, int target, int protocol, int txpar, int rxpar );
extern int  cim_get_link_if_protocol( int link_id );
extern int  cim_get_type( int link_id );
extern int  cim_disconnect_link( int fd, int link_id );
extern int  cim_switch_link( int fd, int link_id, int target, int protocol, int txpar, int rxpar );
extern void cim_display_current_setup( int link_id );
extern int  cim_select_linkif_and_line( int fd, int link_id );
extern int  cim_poll_once( int fd, unsigned int timeout, FPD_event_t *pevent );
extern int  cim_get_stats( int fd, int link_id );

#endif /* _CIM_ */
