/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  CIM Protocol Diagnostics Menu header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _CIM_MENU_H_
#define _CIM_MENU_H_

typedef enum {
    PCIM_MENU_EXIT,
    PCIM_MENU_SEND_ECHO,                       /* 1 */
    PCIM_MENU_SEND_KEYBD_MOUSE_INIT,
    PCIM_MENU_SEND_BEEP,
    PCIM_MENU_SEND_READ_EEPROM,
    PCIM_MENU_SEND_WRITE_EEPROM,               /* 5 */
    PCIM_MENU_SEND_KEYBD_PKTS,
    PCIM_MENU_SEND_MOUSE_PKTS,
    PCIM_MENU_CIM_EEPROM_UTILS,
    PCIM_MENU_KEYBD_LOOP_TEST,
    PCIM_MENU_CIM_UPDATE_INIT,                 /* 10 */
    PCIM_MENU_CIM_UPDATE_RECOVERY,
    PCIM_MENU_POWER_CIM_UTILS,
    NUM_PCIM_MENU
} pcim_menu_t;

typedef enum {
    PCIM_EEPROM_MENU_EXIT,
    PCIM_EEPROM_MENU_GET_SERNUM,
    PCIM_EEPROM_MENU_GET_TIMESTAMP,
    PCIM_EEPROM_MENU_GET_CHANNEL_NAME,
    PCIM_EEPROM_MENU_GET_DEVICE_TYPE,
    PCIM_EEPROM_MENU_GET_FWVER,
    PCIM_EEPROM_MENU_GET_HWVER,
    PCIM_EEPROM_MENU_SET_TIMESTAMP,
    PCIM_EEPROM_MENU_SET_CHANNEL_NAME,
    NUM_PCIM_EEPROM_MENU
} pcim_eeprom_menu_t;

typedef enum {
    PCIM_POWER_MENU_EXIT,
    PCIM_POWER_MENU_GET_INFO,
    PCIM_POWER_MENU_READ_EEPROM,
    PCIM_POWER_MENU_WRITE_EEPROM,
    PCIM_POWER_MENU_ENTER_BSNMP,
    PCIM_POWER_MENU_SNMPON,
    PCIM_POWER_MENU_SNMPON_OUTLET,
    PCIM_POWER_MENU_SPOFF,
    PCIM_POWER_MENU_SPOFF_OUTLET,
    PCIM_POWER_MENU_SNMPS,
    PCIM_POWER_MENU_USER_DEFINED,
    NUM_PCIM_POWER_MENU
} pcim_power_menu_t;

typedef enum {
    CIM_UPDATE_MENU_EXIT,
    CIM_UPDATE_SEND_FC,
    NUM_CIM_UPDATE_MENU
} cim_update_menu_t;

typedef enum {
    VMCIM_MENU_EXIT,
    VMCIM_MENU_INIT_PKTS,
    VMCIM_MENU_INFO_PKTS,
    VMCIM_MENU_CNTL_PKTS,
    VMCIM_MENU_MEM_PKTS,
    VMCIM_MENU_KBD_PKTS,
    VMCIM_MENU_MOUSE_PKTS,
    VMCIM_MENU_USBCTL_PKTS,
    NUM_VMCIM_MENU
} vmcim_menu_t;

typedef enum {
    VMCIM_INIT_MENU_EXIT,
    VMCIM_INIT_MENU_RESET,
    VMCIM_INIT_MENU_INIT,
    NUM_VMCIM_INIT_MENU
} vmcim_init_menu_t;

typedef enum {
    VMCIM_INFO_MENU_EXIT,
    VMCIM_INFO_MENU_FW_VERSION,
    VMCIM_INFO_MENU_HW_VERSION,
    VMCIM_INFO_MENU_FPGA_VERSION,
    VMCIM_INFO_MENU_PROTOCOL_VERSION,
    VMCIM_INFO_MENU_BTLDR_VERSION,
    VMCIM_INFO_MENU_CIM_HEARTBEAT,
    VMCIM_INFO_MENU_LINK_STATS,
    VMCIM_INFO_MENU_CIM_FPGA_ERROR,
    VMCIM_INFO_MENU_CIM_FPGA_READ,
    NUM_VMCIM_INFO_MENU
} vmcim_info_menu_t;

typedef enum {
    VMCIM_CNTL_MENU_EXIT,
    VMCIM_CNTL_MENU_SET_CCV_ON,
    VMCIM_CNTL_MENU_SET_CCV_OFF,
    VMCIM_CNTL_MENU_SET_TXTIMEOUT,
    VMCIM_CNTL_MENU_SET_LED_OFF,
    VMCIM_CNTL_MENU_SET_LED_ON,
    VMCIM_CNTL_MENU_SET_LED_TOGGLE,
    VMCIM_CNTL_MENU_ENTER_CIM_BUFFER_LPBK_TEST,
    VMCIM_CNTL_MENU_ENTER_PRI_BUFFER_LPBK_TEST,
    VMCIM_CNTL_MENU_EXIT_LPBK_TEST,
    VMCIM_CNTL_MENU_EXIT_TEST,
    VMCIM_CNTL_MENU_CIM_FPGA_WRITE,
    NUM_VMCIM_CNTL_MENU
} vmcim_cntl_menu_t;

typedef enum {
    VMCIM_MEM_MENU_EXIT,
    VMCIM_MEM_MENU_WRITE_EEPROM,
    VMCIM_MEM_MENU_READ_EEPROM,
    NUM_VMCIM_MEM_MENU
} vmcim_mem_menu_t;

typedef enum {
    VMCIM_KBD_MENU_EXIT,
    VMCIM_KBD_MENU_SET_MODEL,
    VMCIM_KBD_MENU_SET_LANG,
    VMCIM_KBD_MENU_GET_LED_SETTINGS,
    VMCIM_KBD_MENU_SEND_DATA,
    NUM_VMCIM_KBD_MENU
} vmcim_kbd_menu_t;

typedef enum {
    VMCIM_MOUSE_MENU_EXIT,
    VMCIM_MOUSE_MENU_SET_MODE,
    VMCIM_MOUSE_MENU_SEND_DATA,
    NUM_VMCIM_MOUSE_MENU
} vmcim_mouse_menu_t;

typedef enum {
    VMCIM_USBCTL_MENU_EXIT,
    VMCIM_USBCTL_MENU_DISCONNECT,
    VMCIM_USBCTL_MENU_CONNECT,
    VMCIM_USBCTL_MENU_CONFIGURATION,
    VMCIM_USBCTL_MENU_STALL_BULKEP,
    VMCIM_USBCTL_MENU_MS_RESET_RSP,
    VMCIM_USBCTL_MENU_CLR_FEAT_HALT_RSP,
    NUM_VMCIM_USBCTL_MENU
} vmcim_usbctl_menu_t;

extern int cim_menu(int fd, int link);

#endif /* _CIM_MENU_ */
