/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  Paragon CIM Protocol Utilities header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _PARAGON_CIM_H_
#define _PARAGON_CIM_H_

/* Paragon CIM EEPROM offsets */
#define PCIM_EEPROM_SERIAL_NUMBER                      (0x08 >> 1)
#define PCIM_EEPROM_TIMESTAMP                          (0x0E >> 1)
#define PCIM_EEPROM_CHANNEL_NAME                       (0x1C >> 1)
#define PCIM_EEPROM_NAME_EXTENSION                     (0x34 >> 1)
#define PCIM_EEPROM_DEVICE_TYPE                        (0x62 >> 1)
#define PCIM_EEPROM_FW_VERSION                         (0x65 >> 1)
#define PCIM_EEPROM_HW_VERSION                         (0x69 >> 1)

/* Paragon CIM EEPROM field sizes */
#define PCIM_EEPROM_SERIAL_NUMBER_SIZE                 6
#define PCIM_EEPROM_TIMESTAMP_SIZE                     2
#define PCIM_EEPROM_CHANNEL_NAME_SIZE                  12
#define PCIM_EEPROM_NAME_EXTENSION_SIZE                8
#define PCIM_EEPROM_DEVICE_TYPE_SIZE                   3
#define PCIM_EEPROM_FW_VERSION_SIZE                    4
#define PCIM_EEPROM_HW_VERSION_SIZE                    4

/* Dominion CIM EEPROM offsets */
#define DCIM_EEPROM_SERIAL_NUMBER                      (0x08 >> 1)
#define DCIM_EEPROM_TIMESTAMP                          (0x0E >> 1)
#define DCIM_EEPROM_CHANNEL_NAME                       (0x1C >> 1)
#define DCIM_EEPROM_DEVICE_TYPE                        (0x62 >> 1)
#define DCIM_EEPROM_FW_VERSION                         (0x65 >> 1)
#define DCIM_EEPROM_HW_VERSION                         (0x69 >> 1)

/* Dominion CIM EEPROM field sizes */
#define DCIM_EEPROM_SERIAL_NUMBER_SIZE                 6
#define DCIM_EEPROM_TIMESTAMP_SIZE                     2
#define DCIM_EEPROM_CHANNEL_NAME_SIZE                  20
#define DCIM_EEPROM_DEVICE_TYPE_SIZE                   3
#define DCIM_EEPROM_FW_VERSION_SIZE                    4
#define DCIM_EEPROM_HW_VERSION_SIZE                    4

/* Device ID - answer to ECHO Request */
#define DEVICE_ID_POWER_CIM_OLD                        0x30
#define DEVICE_ID_POWER_CIM_NEW                        0x31
#define DEVICE_ID_PC_CIM                               0x80
#define DEVICE_ID_P2CIM_PS2DUAL                        0x82
#define DEVICE_ID_SUN_CIM                              0x84

enum rx_paragon_cmd {
    PCMD_AUTO_SKEW              = 0x03,
    PCMD_VIDEO_PHSYNC_PVSYNC    = 0x04,
    PCMD_VIDEO_PHSYNC_NVSYNC    = 0x05,
    PCMD_VIDEO_NHSYNC_PVSYNC    = 0x06,
    PCMD_VIDEO_NHSYNC_NVSYNC    = 0x07,
    PCMD_PS2KBD_DATA1           = 0x09,
    PCMD_PS2KBD_DATA2           = 0x0A,
    PCMD_SUNKBD_DATA1           = 0x0D,
    PCMD_SUNKBD_DATA2           = 0x0E,
    PCMD_SUNKBD_DATA3           = 0x0F,
    PCMD_CIM_CONFIGURATION      = 0x10,
    PCMD_PS2MOUSE_CMD1          = 0x11,
    PCMD_PS2MOUSE_CMD2          = 0x12,
    PCMD_BEEP                   = 0x15,
    PCMD_CIM_EEPROM_REPORT      = 0x64,
    PCMD_FOR_POWER_CIM          = 0x6E,
    PCMD_FOR_POWER_STRIP        = 0x6F,

    /* CIM FW Update */
    PCMD_CIM_UPDATE_DEV_TYPE    = 0xC9,
    PCMD_CIM_UPDATE_CONT_SEND   = 0xF4,
    PCMD_CIM_UPDATE_ERASE_ERR   = 0xF6,
    PCMD_CIM_UPDATE_PROG_ERR    = 0xF7,
    PCMD_CIM_UPDATE_BLKCHK_ERR  = 0xF8,
    PCMD_CIM_UPDATE_ACK         = 0xFA,
    PCMD_CIM_UPDATE_NACK        = 0xFE,
};

enum tx_paragon_cmd {
    PCMD_KBMS_INIT              = 0x01,
    PCMD_ECHO_REQUEST           = 0x30,
    PCMD_READ_CIM_EEPROM        = 0x62,
    PCMD_WRITE_CIM_EEPROM       = 0x63,
};

enum power_cmd {
    POWER_REQUEST_INFO          = 0x01,
    POWER_READ_EEPROM           = 0x02,
    POWER_WRITE_EEPROM          = 0x03,
    POWER_ENTER_BSNMP           = 0x04,
};

enum power_strip_cmd {
    POWER_STRIP_CMD_DATA        = 0x01,
};

enum snmp_cmd {
    SNMPON,
    SNMPON_OUTLET,
    SPOFF,
    SPOFF_OUTLET,
    SNMPS,
    USER_DEFINED,
};

typedef struct {
    unsigned char cmd;
    unsigned char addr;
    unsigned char datalo;
    unsigned char datahi;
} pcim_eeprom_report_t;

typedef struct {
    unsigned short addr;
    unsigned char  len;
} powercim_eepromrd_t;

typedef struct {
    unsigned short addr;
    unsigned char  len;
    unsigned char  data[64];
} powercim_eepromwr_t;

typedef union {
    powercim_eepromrd_t   eeprom_rd;
    powercim_eepromwr_t   eeprom_wr;
} powercim_msg_t;

extern unsigned char compute_paragon_chksum( unsigned char *pbuf, int len );
extern void dump_data( unsigned char *bufaddr, int pktlen );

extern int  paragon_cim_init( int fd, int link_if, int connected );
extern int  paragon_cim_send_pkt( int fd, unsigned int link_if, FPD_data_t *pdata );
extern int  paragon_cim_receive_pkt( int fd, unsigned int link_if, FPD_data_t *pdata );
extern int  paragon_cim_send_echo( int fd, int link_if, unsigned char *pdev_id );
extern int  paragon_cim_send_kbms_init( int fd, int link_if );
extern int  paragon_cim_send_beep( int fd, int link_if, unsigned char beep_time );
extern int  paragon_cim_send_eeprom_read( int fd, int link_if, char offset, pcim_eeprom_report_t *preport );
extern int  paragon_cim_send_eeprom_write( int fd, int link_if, char offset, char datalo, char datahi );
extern int  paragon_cim_get_serial_number( int fd, int link_if );
extern int  paragon_cim_get_timestamp( int fd, int link_if );
extern int  paragon_cim_get_channel_name( int fd, int link_if );
extern int  paragon_cim_get_device_type( int fd, int link_if, char *ptype );
extern int  paragon_cim_get_fw_version( int fd, int link_if );
extern int  paragon_cim_get_hw_version( int fd, int link_if );
extern int  paragon_cim_set_timestamp( int fd, int link_if );
extern int  paragon_cim_set_channel_name( int fd, int link_if );
extern void paragon_cim_set_display_rxpkt( char val);
extern int  paragon_cim_send_power_cmd( int fd, int link_if, char id, powercim_msg_t *pmsg );
extern int  paragon_cim_send_power_strip_cmd( int fd, int link_if, char id, char *pbuf );

#endif /* _PARAGON_CIM_H_ */
