/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  Virtual Media CIM Loopback Test Utilities Header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _VM_LPBK_H_
#define _VM_LPBK_H_

#define POLL_TIMEOUT                           (60 * 1000)
#define RETRY_TIMEOUT                          (60)

typedef enum {
    PKT_PATTERN_8BIT_ASCENDING = 0,
    PKT_PATTERN_8BIT_DESCENDING,
    PKT_PATTERN_8BIT_REPEATING,
    PKT_PATTERN_16BIT_ASCENDING,
    PKT_PATTERN_16BIT_DESCENDING,
    PKT_PATTERN_32BIT_ASCENDING,
    PKT_PATTERN_32BIT_DESCENDING,
} pkt_pattern_t;

extern int vm_lpbk_init( void );
extern int send_protocol_data_continuously( int fd, unsigned int link_if, int btype, int option, int dopt );
extern int receive_protocol_data_continuously( int fd, unsigned int link_if, int btype, int option, int dopt );
extern int receive_protocol_data_no_verification( int fd, unsigned int link_if, int btype, int option, int dopt );

#endif /* _VM_LPBK_H_ */
