/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Diagnostics Menu header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_MENU_H_
#define _FPD_MENU_H_

typedef enum {
    FPD_MENU_EXIT,
    FPD_MENU_DISPLAY_INFO,                       /* 1 */
    FPD_MENU_DISPLAY_PCI_CFG,
    FPD_MENU_READ_REG,
    FPD_MENU_WRITE_REG,
    FPD_MENU_SELECT_MASTER_SLAVE,                /* 5 */
    FPD_MENU_SELECT_LINK_AND_LINE_IF,
    FPD_MENU_RESET_LINKIF,
    FPD_MENU_WRITE_BUFFER,
    FPD_MENU_READ_BUFFER,
    FPD_MENU_PROTOCOL_AND_DMA_DATA_TESTS,        /* 10 */
    FPD_MENU_GET_LINK_STATS,
    FPD_MENU_CHECK_EVENTS,
    FPD_MENU_GET_LINK_ERRORS,
    FPD_MENU_GET_PCI_ERRORS,
    FPD_MENU_SET_DMA_BURST_SIZE,                 /* 15 */
    FPD_MENU_GET_DMA_BURST_SIZE,
    FPD_MENU_LEGACY_CIM_TESTS,
    FPD_MENU_SET_CABLE_TYPE,
    FPD_MENU_TEST_KXGEN2_VM_PORT,
    FPD_MENU_TEST_RECEIVER_VM_PORT,
    NUM_FPD_MENU
} fpd_menu_t;

typedef enum {
    FPD_BUF_MENU_EXIT,
    FPD_BUF_MENU_DISPLAY_PKT_INFO,
    FPD_BUF_MENU_CHANGE_BUFFER_TYPE,
    FPD_BUF_MENU_CHANGE_PKT,
    FPD_BUF_MENU_SEND_PKT,
    FPD_BUF_MENU_RECEIVE_PKT,
    FPD_BUF_MENU_SEND_PKT_WITH_CRC_ERROR,
    FPD_BUF_MENU_RECEIVE_PKT_WITH_CRC_ERROR,
    FPD_BUF_MENU_SEND_PKT_WITH_PROTOCOL_ERROR,
    FPD_BUF_MENU_RECEIVE_PKT_WITH_PROTOCOL_ERROR,
    FPD_BUF_MENU_SEND_INVALID_PKT,
    FPD_BUF_MENU_RECEIVE_INVALID_PKT,
    FPD_BUF_MENU_TEST_BUFFER_FULL_TXSIDE,
    FPD_BUF_MENU_TEST_BUFFER_FULL_RXSIDE_ON,
    FPD_BUF_MENU_TEST_BUFFER_FULL_RXSIDE_OFF,
    FPD_BUF_MENU_CONTINUOUSLY_SEND_PKTS,
    FPD_BUF_MENU_CONTINUOUSLY_RECEIVE_PKTS,
    NUM_FPD_BUF_MENU
} fpd_buf_menu_t;

typedef enum {
    FPD_LEGACY_CIM_MENU_EXIT,
    FPD_LEGACY_CIM_MENU_DISPLAY_SETUP,
    FPD_LEGACY_CIM_MENU_DISPLAY_CMDS,
    FPD_LEGACY_CIM_MENU_CHANGE_SETUP,
    FPD_LEGACY_CIM_MENU_CHANGE_PKT,
    FPD_LEGACY_CIM_MENU_SEND_PKT,
    FPD_LEGACY_CIM_MENU_RECEIVE_PKT,
    FPD_LEGACY_CIM_MENU_CONTINUOUSLY_SEND_PKTS,
    FPD_LEGACY_CIM_MENU_CONTINUOUSLY_RECEIVE_PKTS,
} fpd_legacy_cim_menu_t;

extern int fpd_menu(int fd);

#endif /* _FPD_MENU_ */
