/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Diagnostic Utilities header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _HOST_H_
#define _HOST_H_

extern int  init_host_module( int fd, int overall_buf_len );
extern void cleanup_host_module( void );
extern int  set_host_configuration( int fd, unsigned int link_if, unsigned int host_chan );
extern int  get_host_configuration( int fd, unsigned int link_if, unsigned int host_chan );
extern int  read_host_data_manually( int fd, unsigned int link_if, unsigned int host_chan );
extern int  send_host_data( int fd, unsigned int link_if, unsigned int host_chan, int pkt_size );
extern int  receive_host_data( int fd, unsigned int link_if, unsigned int host_chan, int pkt_size );
extern int  send_host_data_continuously( int fd, unsigned int link_if, unsigned int host_chan );
extern int  receive_host_data_continuously( int fd, unsigned int link_if, unsigned int host_chan );

#endif /* _HOST_H_ */
