/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Debug Header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_DEBUG_H_
#define _FPD_DEBUG_H_

extern const char *fpd_module_name;

#ifndef TRACE_DISABLE
extern int fpd_trace_on;
extern int fpd_debug_level;

#define FPD_TRACE_ENTER(x)  { if( fpd_trace_on ) \
			printk(KERN_INFO "%s: >>> %s\n", fpd_module_name, x); }
#define FPD_TRACE_EXIT(x)   { if( fpd_trace_on ) \
			printk(KERN_INFO "%s: <<< %s\n", fpd_module_name, x); }
#define FPD_DEV_ENTER(d)  { if( fpd_trace_on ) \
	printk(KERN_INFO "%s%d: >>> %s\n", fpd_module_name, d, __FUNCTION__); }
#define FPD_DEV_EXIT(d)   { if( fpd_trace_on ) \
	printk(KERN_INFO "%s%d: <<< %s\n", fpd_module_name, d,__FUNCTION__); }
#define FPD_DEBUG(l,f,x...)	{ if( l <= fpd_debug_level ) \
			printk(KERN_INFO "%s: "f, fpd_module_name , ##x); }
#define FPD_DDEBUG(d,l,f,x...) { if( l <= fpd_debug_level ) \
                     printk(KERN_INFO "%s%d: "f, fpd_module_name, d, ##x); }

#else /* TRACE_DISABLE */
#define FPD_TRACE_ENTER(m,x)
#define FPD_TRACE_EXIT(m,y)
#define FPD_DEV_ENTER(d)
#define FPD_DEV_EXIT(d)
#define FPD_DEBUG(l,f,x...)
#define FPD_DEBUG(d,l,f,x...)
#endif /* !TRACE_DISABLE */

#define FPD_INFO(f,x...) 	printk(KERN_INFO "%s: "f, \
			 			fpd_module_name , ##x)
#define FPD_DINFO(d,f,x...) 	printk(KERN_INFO "%s%d: "f, \
			 			fpd_module_name , d, ##x)
#define FPD_WARNING(f,x...)	printk(KERN_WARNING "%s WARN: "f, \
			 			fpd_module_name , ##x)
#define FPD_ERROR(f,x...)	printk(KERN_ERR "%s ERROR: "f, \
			 			fpd_module_name , ##x)
#define FPD_DERROR(d,f,x...)	printk(KERN_ERR "%s%d ERROR: "f, \
			 			fpd_module_name , d, ##x)

#endif /* _FPD_DEBUG_H_ */
