/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver DMA Buffer header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2005-2006 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _DMAMEM_H_
#define _DMAMEM_H_

typedef struct
{
    void *physicalAddress;	// Memory Physical address
    void *busAddress;		// PCI Bus address
    void *virtualAddress;	// Kernel address for the RAM
    int   size;
} DMA_MEM;

extern int  dma_buffer_alloc( int bytes, DMA_MEM *pDmaMem );
extern int  dma_buffer_free( DMA_MEM *pDmaMem );
extern int  dma_buffer_init( int totalRequired );
extern void dma_buffer_cleanup( void );

#endif /* _DMAMEM_H_ */
