/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  Intersil EL4544 Crosspoint Switch Header File
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _EL4544_H_
#define _EL4544_H_

#define EL4544_Ai_INPUT_MUX                             0x00
#define EL4544_Bi_INPUT_MUX                             0x10
#define EL4544_Ci_INPUT_MUX                             0x20
#define EL4544_Di_INPUT_MUX                             0x30
#define EL4544_ENABLE_INPUT_MUX                         0x40
#define EL4544_Ti_INPUT_TEST_MUX                        0x50
#define EL4544_TEST_MUX                                 0x60
#define EL4544_SYNC_DETECTORS                           0x70
#define EL4544_Ax_CROSSPOINT_MUX                        0x80
#define EL4544_Bx_CROSSPOINT_MUX                        0x90
#define EL4544_Cx_CROSSPOINT_MUX                        0xA0
#define EL4544_Dx_CROSSPOINT_MUX                        0xB0
#define EL4544_Sx_CROSSPOINT_MUX                        0xC0
#define EL4544_SYNC_OVERLAY_CALIBRATION                 0xD0
#define EL4544_GAIN_INPUT_MUX                           0xE0

/* Ax/Bx/Cx/Dx Crosspoint Mux */
#define EL4544_CPMUX_ENABLE                             0x08
#define EL4544_CPMUX_GAIN                               0x04

/* Gain Input Mux */
#define EL4544_GAIN_2                                   0x0F
#define EL4544_GAIN_1                                   0x00

/* Enable Input Mux */
#define EL4544_ENABLE_INPUT_Ai                          0x01
#define EL4544_ENABLE_INPUT_Bi                          0x02
#define EL4544_ENABLE_INPUT_Ci                          0x04
#define EL4544_ENABLE_INPUT_Di                          0x08

/* Sync Detectors */
#define EL4544_ENABLE_ALL_SYNC_DETECTORS                0x0F

#endif /* _EL4544_H_ */
